/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.path.node;

import java.util.Collection;
import java.util.List;
import top.redscorpion.core.bean.path.node.Node;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;

public class RangeNode
implements Node {
    private final int start;
    private final int end;
    private final int step;

    public RangeNode(String expression) {
        List<String> parts = RsSplit.splitTrim(expression, ":");
        this.start = Integer.parseInt(parts.get(0));
        this.end = Integer.parseInt(parts.get(1));
        int step = 1;
        if (3 == parts.size()) {
            step = Integer.parseInt(parts.get(2));
        }
        this.step = step;
    }

    @Override
    public Object getValue(Object bean) {
        if (bean instanceof Collection) {
            return RsColl.sub((Collection)bean, this.start, this.end, this.step);
        }
        if (RsArray.isArray(bean)) {
            return RsArray.sub(bean, this.start, this.end, this.step);
        }
        throw new UnsupportedOperationException("Can not get range value for: " + bean.getClass());
    }

    @Override
    public Object setValue(Object bean, Object value) {
        throw new UnsupportedOperationException("Can not set value with step name.");
    }

    public String toString() {
        return RsString.format("[{}:{}:{}]", this.start, this.end, this.step);
    }
}

