/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.template.engine.thymeleaf;

import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import top.redscorpion.core.reflect.AbstractTypeReference;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.template.Template;

public class ThymeleafTemplate
implements Template,
Serializable {
    private static final long serialVersionUID = 781284916568562509L;
    private final TemplateEngine engine;
    private final String template;
    private final Charset charset;

    public static ThymeleafTemplate wrap(TemplateEngine engine, String template, Charset charset) {
        return null == engine ? null : new ThymeleafTemplate(engine, template, charset);
    }

    public ThymeleafTemplate(TemplateEngine engine, String template, Charset charset) {
        this.engine = engine;
        this.template = template;
        this.charset = RsObject.defaultIfNull(charset, RsCharset.UTF_8);
    }

    @Override
    public void render(Map<?, ?> bindingMap, Writer writer) {
        Map<String, Object> map = RsConvert.convert(new AbstractTypeReference<Map<String, Object>>(){}, bindingMap);
        Context context = new Context(Locale.getDefault(), map);
        this.engine.process(this.template, (IContext)context, writer);
    }

    @Override
    public void render(Map<?, ?> bindingMap, OutputStream out) {
        this.render(bindingMap, RsIo.toWriter(out, this.charset));
    }
}

