/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.server.filter;

import top.redscorpion.core.exception.RsExceptionHandle;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.server.HttpServerRequest;
import top.redscorpion.http.server.HttpServerResponse;
import top.redscorpion.http.server.filter.ExceptionFilter;

public class DefaultExceptionFilter
extends ExceptionFilter {
    private static final String TEMPLATE_ERROR = "<!DOCTYPE html><html><head><title>RS - Error report</title><style>h1,h3 {color:white; background-color: gray;}</style></head><body><h1>HTTP Status {} - {}</h1><hr size=\"1\" noshade=\"noshade\" /><p>{}</p><hr size=\"1\" noshade=\"noshade\" /><h3>RS</h3></body></html>";

    @Override
    public void afterException(HttpServerRequest req, HttpServerResponse res, Throwable e) {
        String content = RsExceptionHandle.stacktraceToString(e);
        content = content.replace("\n", "<br/>\n");
        content = RsString.format(TEMPLATE_ERROR, 500, req.getUri(), content);
        res.sendError(500, content);
    }
}

