/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.html;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsEscape;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.html.HTMLFilter;

public class RsHtml {
    public static final Pattern RE_HTML_MARK = Pattern.compile("(<[^<]*?>)|(<\\s*?/[^<]*?>)|(<[^<]*?/\\s*?>)", 2);
    public static final Pattern RE_SCRIPT = Pattern.compile("<\\s*?script[^>]*?>.*?<\\s*?/\\s*?script\\s*?>", 2);
    public static final Pattern META_CHARSET_PATTERN = Pattern.compile("<meta[^>]*?charset\\s*=\\s*['\"]?([a-z0-9-]*)", 2);
    private static final char[][] TEXT = new char[256][];

    public static String escape(String text) {
        return RsHtml.encode(text);
    }

    public static String unescape(String htmlStr) {
        if (RsString.isBlank(htmlStr)) {
            return htmlStr;
        }
        return RsEscape.unescapeHtml4(htmlStr);
    }

    public static String cleanHtmlTag(String content) {
        return RsRegular.replaceAll((CharSequence)content, RE_HTML_MARK, "");
    }

    public static String removeScriptTag(String content) {
        return RsRegular.replaceAll((CharSequence)content, RE_SCRIPT, "");
    }

    public static String removeHtmlTag(String content, String ... tagNames) {
        return RsHtml.removeHtmlTag(content, true, tagNames);
    }

    public static String unwrapHtmlTag(String content, String ... tagNames) {
        return RsHtml.removeHtmlTag(content, false, tagNames);
    }

    public static String removeHtmlTag(String content, boolean withTagContent, String ... tagNames) {
        for (String tagName : tagNames) {
            if (RsString.isBlank(tagName)) continue;
            tagName = tagName.trim();
            String regex = withTagContent ? RsString.format("(?i)<{}(\\s+[^>]*?)?/?>(.*?</{}>)?", tagName, tagName) : RsString.format("(?i)<{}(\\s+[^>]*?)?/?>|</?{}>", tagName, tagName);
            content = RsRegular.delAll(regex, (CharSequence)content);
        }
        return content;
    }

    public static String removeHtmlAttr(String content, String ... attrs) {
        for (String attr : attrs) {
            String regex = RsString.format("(?i)(\\s*{}\\s*=\\s*)(([\"][^\"]+?[\"])|([^>]+?\\s*(?=\\s|>)))", attr);
            content = content.replaceAll(regex, "");
        }
        content = RsRegular.replaceAll((CharSequence)content, "\\s+(>|/>)", "$1");
        return content;
    }

    public static String removeAllHtmlAttr(String content, String ... tagNames) {
        for (String tagName : tagNames) {
            String regex = RsString.format("(?i)<{}[^>]*?>", tagName);
            content = content.replaceAll(regex, RsString.format("<{}>", tagName));
        }
        return content;
    }

    private static String encode(String text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(len + (len >> 2));
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c < '\u0100') {
                buffer.append(TEXT[c]);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String filter(String htmlContent) {
        return new HTMLFilter().filter(htmlContent);
    }

    public static String getString(InputStream in, Charset charset, boolean isGetCharsetFromContent) {
        byte[] contentBytes = RsIo.readBytes(in);
        return RsHtml.getString(contentBytes, charset, isGetCharsetFromContent);
    }

    public static String getString(byte[] contentBytes, Charset charset, boolean isGetCharsetFromContent) {
        String charsetInContentStr;
        if (null == contentBytes) {
            return null;
        }
        if (null == charset) {
            charset = RsCharset.UTF_8;
        }
        String content = new String(contentBytes, charset);
        if (isGetCharsetFromContent && RsString.isNotBlank(charsetInContentStr = RsRegular.get(META_CHARSET_PATTERN, (CharSequence)content, 1))) {
            Charset charsetInContent;
            block7: {
                charsetInContent = null;
                try {
                    charsetInContent = Charset.forName(charsetInContentStr);
                }
                catch (Exception e) {
                    if (RsString.containsIgnoreCase(charsetInContentStr, "utf-8") || RsString.containsIgnoreCase(charsetInContentStr, "utf8")) {
                        charsetInContent = RsCharset.UTF_8;
                    }
                    if (!RsString.containsIgnoreCase(charsetInContentStr, "gbk")) break block7;
                    charsetInContent = RsCharset.GBK;
                }
            }
            if (null != charsetInContent && !charset.equals(charsetInContent)) {
                content = new String(contentBytes, charsetInContent);
            }
        }
        return content;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            RsHtml.TEXT[i] = new char[]{(char)i};
        }
        RsHtml.TEXT[39] = "&#039;".toCharArray();
        RsHtml.TEXT[34] = "&quot;".toCharArray();
        RsHtml.TEXT[38] = "&amp;".toCharArray();
        RsHtml.TEXT[60] = "&lt;".toCharArray();
        RsHtml.TEXT[62] = "&gt;".toCharArray();
        RsHtml.TEXT[160] = "&nbsp;".toCharArray();
    }
}

