/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.jdk;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.reflect.RsField;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsSystem;
import top.redscorpion.http.HttpException;

public class RsHttpUrlConnection {
    private static final String[] METHODS = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE", "PATCH"};

    public static void allowPatchQuietly() {
        try {
            RsHttpUrlConnection.allowPatch();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void allowPatch() {
        RsHttpUrlConnection.doAllowPatch();
    }

    private static synchronized void doAllowPatch() {
        Field methodsField = RsField.getField(HttpURLConnection.class, "methods");
        if (null == methodsField) {
            throw new HttpException("None static field [methods] with Java version: [{}]", RsSystem.get("java.version"));
        }
        RsModifier.removeFinalModify(methodsField);
        Object staticFieldValue = RsField.getStaticFieldValue(methodsField);
        if (!RsArray.equals(METHODS, staticFieldValue)) {
            RsField.setStaticFieldValue(methodsField, METHODS);
        }
    }

    public static HttpURLConnection openHttp(URL url, Proxy proxy) throws IORuntimeException {
        URLConnection conn = RsHttpUrlConnection.openConnection(url, proxy);
        if (!(conn instanceof HttpURLConnection)) {
            throw new HttpException("'{}' of URL [{}] is not a http connection, make sure URL is format for http.", conn.getClass().getName(), url);
        }
        return (HttpURLConnection)conn;
    }

    private static URLConnection openConnection(URL url, Proxy proxy) throws IORuntimeException {
        try {
            return null == proxy ? url.openConnection() : url.openConnection(proxy);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

