/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.httpclient4;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.net.url.UrlBuilder;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.GlobalHeaders;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.http.client.engine.httpclient4.HttpClient4BodyEntity;
import top.redscorpion.http.client.engine.httpclient4.HttpClient4Response;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.proxy.HttpProxy;
import top.redscorpion.http.ssl.SSLInfo;

public class HttpClient4Engine
implements ClientEngine {
    private ClientConfig config;
    private CloseableHttpClient engine;

    @Override
    public HttpClient4Engine init(ClientConfig config) {
        this.config = config;
        RsIo.closeQuietly(new AutoCloseable[]{this.engine});
        this.engine = null;
        return this;
    }

    @Override
    public Response send(Request message) {
        CloseableHttpResponse response;
        this.initEngine();
        HttpUriRequest request = HttpClient4Engine.buildRequest(message);
        try {
            response = this.engine.execute(request);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        return new HttpClient4Response(response, message.charset());
    }

    @Override
    public Object getRawEngine() {
        return this.engine;
    }

    @Override
    public void close() throws IOException {
        this.engine.close();
    }

    private void initEngine() {
        if (null != this.engine) {
            return;
        }
        HttpClientBuilder clientBuilder = HttpClients.custom();
        ClientConfig config = RsObject.defaultIfNull(this.config, ClientConfig::of);
        SSLInfo sslInfo = config.getSslInfo();
        if (null != sslInfo) {
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)HttpClient4Engine.buildSocketFactory(sslInfo));
        }
        if (config.isDisableCache()) {
            clientBuilder.disableAuthCaching();
        }
        clientBuilder.setDefaultRequestConfig(HttpClient4Engine.buildRequestConfig(config));
        clientBuilder.setDefaultHeaders(HttpClient4Engine.toHeaderList(GlobalHeaders.INSTANCE.headers()));
        clientBuilder.disableRedirectHandling();
        HttpClient4Engine.setProxy(clientBuilder, config);
        this.engine = clientBuilder.build();
    }

    private static HttpUriRequest buildRequest(Request message) {
        UrlBuilder url = message.handledUrl();
        Assert.notNull(url, "Request URL must be not null!", new Object[0]);
        URI uri = url.toUri();
        RequestBuilder requestBuilder = RequestBuilder.create((String)message.method().name()).setUri(uri);
        message.headers().forEach((k, v1) -> v1.forEach(v2 -> requestBuilder.addHeader(k, v2)));
        HttpBody body = message.handledBody();
        if (null != body) {
            requestBuilder.setEntity((HttpEntity)new HttpClient4BodyEntity(message.header(HeaderName.CONTENT_TYPE), message.charset(), message.isChunked(), body));
        }
        return requestBuilder.build();
    }

    private static List<Header> toHeaderList(Map<String, ? extends Collection<String>> headersMap) {
        ArrayList<Header> result = new ArrayList<Header>();
        headersMap.forEach((k, v1) -> v1.forEach(v2 -> result.add((Header)new BasicHeader(k, v2))));
        return result;
    }

    private static SSLConnectionSocketFactory buildSocketFactory(SSLInfo sslInfo) {
        return new SSLConnectionSocketFactory(sslInfo.getSslContext(), sslInfo.getProtocols(), null, sslInfo.getHostnameVerifier());
    }

    private static RequestConfig buildRequestConfig(ClientConfig config) {
        int readTimeout;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        int connectionTimeout = config.getConnectionTimeout();
        if (connectionTimeout > 0) {
            requestConfigBuilder.setConnectTimeout(connectionTimeout);
            requestConfigBuilder.setConnectionRequestTimeout(connectionTimeout);
        }
        if ((readTimeout = config.getReadTimeout()) > 0) {
            requestConfigBuilder.setSocketTimeout(readTimeout);
        }
        return requestConfigBuilder.build();
    }

    private static void setProxy(HttpClientBuilder clientBuilder, ClientConfig config) {
        if (null == config) {
            return;
        }
        HttpProxy proxy = config.getProxy();
        if (null != proxy) {
            HttpHost httpHost = new HttpHost(proxy.getHost(), proxy.getPort());
            clientBuilder.setProxy(httpHost);
            PasswordAuthentication auth = proxy.getAuth();
            if (null != auth) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(auth.getUserName(), String.valueOf(auth.getPassword())));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
    }
}

