/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.body;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import top.redscorpion.core.io.stream.FastByteArrayOutputStream;
import top.redscorpion.core.util.RsIo;

public interface HttpBody {
    public void write(OutputStream var1);

    public String getContentType();

    default public String getContentType(Charset charset) {
        String contentType = this.getContentType();
        if (null == contentType) {
            return null;
        }
        return contentType + ";charset=" + charset.name();
    }

    default public void writeClose(OutputStream out) {
        try {
            this.write(out);
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly(out);
            throw throwable;
        }
        RsIo.closeQuietly(out);
    }

    default public InputStream getStream() {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.writeClose(out);
        return RsIo.toStream(out);
    }
}

