/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client;

import top.redscorpion.http.HttpGlobalConfig;
import top.redscorpion.http.proxy.HttpProxy;
import top.redscorpion.http.ssl.SSLInfo;

public class ClientConfig {
    private int connectionTimeout = HttpGlobalConfig.getTimeout();
    private int readTimeout = HttpGlobalConfig.getTimeout();
    private SSLInfo sslInfo = SSLInfo.TRUST_ANY;
    private boolean disableCache;
    private HttpProxy proxy;

    public static ClientConfig of() {
        return new ClientConfig();
    }

    public ClientConfig setTimeout(int milliseconds) {
        this.setConnectionTimeout(milliseconds);
        this.setReadTimeout(milliseconds);
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public ClientConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public SSLInfo getSslInfo() {
        return this.sslInfo;
    }

    public ClientConfig setSSLInfo(SSLInfo sslInfo) {
        this.sslInfo = sslInfo;
        return this;
    }

    public ClientConfig enableSSLVerify() {
        return this.setSSLInfo(SSLInfo.DEFAULT);
    }

    public boolean isDisableCache() {
        return this.disableCache;
    }

    public void setDisableCache(boolean disableCache) {
        this.disableCache = disableCache;
    }

    public HttpProxy getProxy() {
        return this.proxy;
    }

    public ClientConfig setHttpProxy(String host, int port) {
        return this.setProxy(new HttpProxy(host, port));
    }

    public ClientConfig setProxy(HttpProxy proxy) {
        this.proxy = proxy;
        return this;
    }
}

