/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsRandom;
import top.redscorpion.core.util.RsString;
import top.redscorpion.crypto.CryptoException;
import top.redscorpion.crypto.RsSpec;
import top.redscorpion.crypto.provider.GlobalProviderFactory;
import top.redscorpion.crypto.symmetric.SymmetricAlgorithm;

public class RsKey {
    public static SecretKey generateKey(String algorithm) {
        return RsKey.generateKey(algorithm, -1);
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        return RsKey.generateKey(algorithm, keySize, null);
    }

    public static SecretKey generateKey(String algorithm, int keySize, SecureRandom random) {
        algorithm = RsKey.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = RsKey.getKeyGenerator(algorithm);
        if (keySize <= 0 && SymmetricAlgorithm.AES.getValue().equals(algorithm)) {
            keySize = 128;
        }
        if (keySize > 0) {
            if (null == random) {
                keyGenerator.init(keySize);
            } else {
                keyGenerator.init(keySize, random);
            }
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        Assert.notBlank(algorithm, "Algorithm is blank!", new Object[0]);
        SecretKey secretKey = algorithm.startsWith("PBE") ? RsKey.generatePBEKey(algorithm, null == key ? null : RsString.utf8Str(key).toCharArray()) : (algorithm.startsWith("DES") ? RsKey.generateDESKey(algorithm, key) : (null == key ? RsKey.generateKey(algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        if (RsString.isBlank(algorithm) || !algorithm.startsWith("DES")) {
            throw new CryptoException("Algorithm [{}] is not a DES algorithm!", new Object[]{algorithm});
        }
        SecretKey secretKey = null == key ? RsKey.generateKey(algorithm) : RsKey.generateKey(algorithm, RsSpec.createKeySpec(algorithm, key));
        return secretKey;
    }

    public static SecretKey generatePBEKey(String algorithm, char[] password) {
        if (RsString.isBlank(algorithm) || !algorithm.startsWith("PBE")) {
            throw new CryptoException("Algorithm [{}] is not a PBE algorithm!", new Object[]{algorithm});
        }
        if (null == password) {
            password = RsRandom.randomStringLower(32).toCharArray();
        }
        return RsKey.generateKey(algorithm, RsSpec.createPBEKeySpec(password));
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = RsKey.getSecretKeyFactory(algorithm);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) {
        SecretKeyFactory keyFactory;
        Provider provider = GlobalProviderFactory.getProvider();
        try {
            keyFactory = null == provider ? SecretKeyFactory.getInstance(RsKey.getMainAlgorithm(algorithm)) : SecretKeyFactory.getInstance(RsKey.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return keyFactory;
    }

    public static KeyGenerator getKeyGenerator(String algorithm) {
        KeyGenerator generator;
        Provider provider = GlobalProviderFactory.getProvider();
        try {
            generator = null == provider ? KeyGenerator.getInstance(RsKey.getMainAlgorithm(algorithm)) : KeyGenerator.getInstance(RsKey.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return generator;
    }

    public static String getMainAlgorithm(String algorithm) {
        Assert.notBlank(algorithm, "Algorithm must be not blank!", new Object[0]);
        int slashIndex = algorithm.indexOf(47);
        if (slashIndex > 0) {
            return algorithm.substring(0, slashIndex);
        }
        return algorithm;
    }
}

