/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import top.redscorpion.core.util.RsArray;

public class RsSet {
    @SafeVarargs
    public static <T> HashSet<T> of(T ... ts) {
        return RsSet.theOf(false, ts);
    }

    private static <T> HashSet<T> theOf(boolean isLinked, T[] ts) {
        if (RsArray.isEmpty(ts)) {
            return isLinked ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isLinked ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        Collections.addAll(set, ts);
        return set;
    }
}

