/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;
import top.redscorpion.core.util.RsString;

public class RsRandom {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER_LOWER = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecureRandom getSecureRandom() {
        return RsRandom.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return RsRandom.createSecureRandom(seed);
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        RsRandom.getRandom().nextBytes(bytes);
        return bytes;
    }

    public static int randomInt() {
        return RsRandom.getRandom().nextInt();
    }

    public static int randomInt(int limitExclude) {
        return RsRandom.getRandom().nextInt(limitExclude);
    }

    public static long randomLong(long limitExclude) {
        return RsRandom.getRandom().nextLong(limitExclude);
    }

    public static String randomString(int length) {
        return RsRandom.randomStringLower(BASE_CHAR_NUMBER, length);
    }

    public static String randomStringLower(int length) {
        return RsRandom.randomStringLower(BASE_CHAR_NUMBER_LOWER, length);
    }

    public static String randomNumber(int length) {
        return RsRandom.randomStringLower(BASE_NUMBER, length);
    }

    public static String randomStringLower(String baseString, int length) {
        if (RsString.isEmpty(baseString)) {
            return "";
        }
        if (length < 1) {
            length = 1;
        }
        StringBuilder sb = new StringBuilder(length);
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RsRandom.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }
}

