/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import top.redscorpion.core.collection.iter.ArrayIter;
import top.redscorpion.core.collection.iter.EnumerationIter;
import top.redscorpion.core.collection.iter.NodeListIter;
import top.redscorpion.core.collection.iter.TransIter;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.method.RsMethod;
import top.redscorpion.core.text.StringJoiner;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsMap;

public class RsIter {
    public static <T> Iterator<T> getIter(Iterable<T> iterable) {
        return null == iterable ? null : iterable.iterator();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || RsIter.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return null == iterator || !iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return null != iterator && iterator.hasNext();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return StringJoiner.of(conjunction).append(iterator).toString();
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values) {
        return RsIter.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values, boolean isOrder) {
        return RsIter.toMap(null == keys ? null : keys.iterator(), null == values ? null : values.iterator(), isOrder);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values, boolean isOrder) {
        HashMap<K, Object> resultMap = RsMap.newHashMap(isOrder);
        if (RsIter.isNotEmpty(keys)) {
            while (keys.hasNext()) {
                resultMap.put(keys.next(), null != values && values.hasNext() ? (Object)values.next() : null);
            }
        }
        return resultMap;
    }

    public static <E> E get(Iterator<E> iterator, int index) throws IndexOutOfBoundsException {
        if (null == iterator) {
            return null;
        }
        Assert.isTrue(index >= 0, "[index] must be >= 0", new Object[0]);
        while (iterator.hasNext()) {
            if (-1 == --index) {
                return iterator.next();
            }
            iterator.next();
        }
        return null;
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        return RsIter.get(iterator, 0);
    }

    public static <T> Iterator<T> empty() {
        return Collections.emptyIterator();
    }

    public static <F, T> Iterator<T> trans(Iterator<F> iterator, Function<? super F, ? extends T> function) {
        return new TransIter<F, T>(iterator, function);
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
        }
        return size;
    }

    public static Iterator<?> getIter(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        if (RsArray.isArray(obj)) {
            return new ArrayIter(obj);
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIter((Enumeration)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().iterator();
        }
        if (obj instanceof NodeList) {
            return new NodeListIter((NodeList)obj);
        }
        if (obj instanceof Node) {
            return new NodeListIter(((Node)obj).getChildNodes());
        }
        if (obj instanceof Dictionary) {
            return new EnumerationIter(((Dictionary)obj).elements());
        }
        try {
            Object iterator = RsMethod.invoke(obj, "iterator", new Object[0]);
            if (iterator instanceof Iterator) {
                return (Iterator)iterator;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new ArrayIter<Object>(new Object[]{obj});
    }
}

