/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.Serializable;
import java.net.URL;
import java.util.List;
import top.redscorpion.core.bean.NullWrapperBean;
import top.redscorpion.core.convert.BasicType;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsClassLoader;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsResource;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsUrl;

public class RsClass {
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';

    public static String getShortClassName(String className) {
        List<String> packages = RsSplit.split(className, ".");
        if (null == packages || packages.size() < 2) {
            return className;
        }
        int size = packages.size();
        StringBuilder result = new StringBuilder();
        result.append(packages.get(0).charAt(0));
        for (int i = 1; i < size - 1; ++i) {
            result.append('.').append(packages.get(i).charAt(0));
        }
        result.append('.').append(packages.get(size - 1));
        return result.toString();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object obj = objects[i];
            classes[i] = obj instanceof NullWrapperBean ? ((NullWrapperBean)obj).getWrappedClass() : (null == obj ? Object.class : obj.getClass());
        }
        return classes;
    }

    public static String getClassPath() {
        return RsClass.getClassPath(false);
    }

    public static String getClassPath(boolean isEncoded) {
        URL classPathUrl = RsResource.getResourceUrl("");
        String url = isEncoded ? classPathUrl.getPath() : RsUrl.getDecodedPath(classPathUrl);
        return RsFile.normalize(url);
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (RsArray.isEmpty(types1) && RsArray.isEmpty(types2)) {
            return true;
        }
        if (null == types1 || null == types2) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(RsClass.isBasicType(type1) && RsClass.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : !type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return BasicType.isPrimitiveWrapper(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || RsClass.isPrimitiveWrapper(clazz);
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            return targetType.equals(BasicType.unWrap(sourceType));
        }
        Class<?> resolvedWrapper = BasicType.wrap(sourceType, true);
        return resolvedWrapper != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isSerializable(Class<?> clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && !clazz.isInterface() && !RsModifier.isAbstract(clazz) && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isPrimitive();
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return RsClass.getPrimitiveDefaultValue(clazz);
        }
        return null;
    }

    public static Object getPrimitiveDefaultValue(Class<?> clazz) {
        if (Long.TYPE == clazz) {
            return 0L;
        }
        if (Integer.TYPE == clazz) {
            return 0;
        }
        if (Short.TYPE == clazz) {
            return (short)0;
        }
        if (Character.TYPE == clazz) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE == clazz) {
            return (byte)0;
        }
        if (Double.TYPE == clazz) {
            return 0.0;
        }
        if (Float.TYPE == clazz) {
            return Float.valueOf(0.0f);
        }
        if (Boolean.TYPE == clazz) {
            return false;
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = RsClass.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static Class<?> forName(String name, boolean isInitialized, ClassLoader loader) {
        if (null == loader) {
            loader = RsClassLoader.getClassLoader();
        }
        name = name.replace('/', '.');
        try {
            return Class.forName(name, isInitialized, loader);
        }
        catch (ClassNotFoundException ex) {
            Class<?> clazz = RsClass.forNameInnerClass(name, isInitialized, loader);
            if (null == clazz) {
                throw new RsException(ex);
            }
            return clazz;
        }
    }

    private static Class<?> forNameInnerClass(String name, boolean isInitialized, ClassLoader classLoader) {
        int lastDotIndex = name.lastIndexOf(46);
        Class<?> clazz = null;
        while (lastDotIndex > 0 && Character.isUpperCase(name.charAt(lastDotIndex + 1))) {
            name = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
            try {
                clazz = Class.forName(name, isInitialized, classLoader);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                lastDotIndex = name.lastIndexOf(46);
            }
        }
        return clazz;
    }
}

