/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import top.redscorpion.core.bean.BeanDesc;
import top.redscorpion.core.bean.BeanDescCache;
import top.redscorpion.core.bean.copier.BeanCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.bean.copier.ValueProvider;
import top.redscorpion.core.lang.mutable.MutableEntry;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.reflect.RsField;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;

public class RsBean {
    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return BeanDescCache.INSTANCE.getBeanDesc(clazz, () -> new BeanDesc(clazz));
    }

    public static Object getFieldValue(Object bean, String fieldNameOrIndex) {
        if (null == bean || null == fieldNameOrIndex) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldNameOrIndex);
        }
        if (bean instanceof Collection) {
            try {
                return RsColl.get((Collection)bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return RsColl.map((Collection)bean, beanEle -> RsBean.getFieldValue(beanEle, fieldNameOrIndex), false);
            }
        }
        if (RsArray.isArray(bean)) {
            try {
                return RsArray.get(bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return RsArray.map(bean, Object.class, beanEle -> RsBean.getFieldValue(beanEle, fieldNameOrIndex));
            }
        }
        return RsField.getFieldValue(bean, fieldNameOrIndex);
    }

    public static <T> T toBean(Object source, Class<T> clazz) {
        return RsBean.toBean(source, clazz, null);
    }

    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        return (T)RsBean.toBean(source, () -> RsConstructor.newInstanceIfPossible(clazz), options);
    }

    public static <T> T toBean(Object source, Supplier<T> targetSupplier, CopyOptions options) {
        if (null == source || null == targetSupplier) {
            return null;
        }
        T target = targetSupplier.get();
        RsBean.copyProperties(source, target, options);
        return target;
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.of(valueProvider, bean, copyOptions).copy();
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return RsBean.beanToMap(bean, new LinkedHashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return RsBean.beanToMap(bean, targetMap, ignoreNullValue, entry -> {
            String key = (String)entry.getKey();
            entry.setKey(isToUnderlineCase ? RsString.toUnderlineCase(key) : key);
            return entry;
        });
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, UnaryOperator<MutableEntry<String, Object>> keyEditor) {
        if (null == bean) {
            return null;
        }
        return BeanCopier.of(bean, targetMap, CopyOptions.of().setIgnoreNullValue(ignoreNullValue).setFieldEditor(keyEditor)).copy();
    }

    public static <T> T copyProperties(Object source, T target, String ... ignoreProperties) {
        return RsBean.copyProperties(source, target, CopyOptions.of().setIgnoreProperties(ignoreProperties));
    }

    public static <T> T copyProperties(Object source, T target, CopyOptions copyOptions) {
        if (null == source || null == target) {
            return null;
        }
        return BeanCopier.of(source, target, RsObject.defaultIfNull(copyOptions, CopyOptions::of)).copy();
    }

    public static boolean isReadableBean(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return RsBean.hasGetter(clazz) || RsBean.hasPublicField(clazz);
    }

    public static boolean isWritableBean(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return RsBean.hasSetter(clazz) || RsBean.hasPublicField(clazz);
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (RsClass.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterCount() != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class<?> clazz) {
        if (RsClass.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                String name;
                if (method.getParameterCount() != 0 || !(name = method.getName()).startsWith("get") && !name.startsWith("is") || "getClass".equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (RsClass.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!RsModifier.isPublic(field) || RsModifier.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return RsBean.beanToMap(bean, false, false);
    }
}

