/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import top.redscorpion.core.array.ArrayWrapper;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.exception.RsExceptionHandle;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.text.StringJoiner;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsPrimitiveArray;
import top.redscorpion.core.util.RsString;

public class RsArray
extends RsPrimitiveArray {
    public static <A> A ofArray(Object values) {
        return RsArray.ofArray(values, null);
    }

    public static <A> A ofArray(Object values, Class<?> elementType) {
        if (RsArray.isArray(values)) {
            return (A)values;
        }
        Object newInstance = Array.newInstance(null == elementType ? values.getClass() : elementType, 1);
        Array.set(newInstance, 0, values);
        return (A)newInstance;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (RsArray.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !RsArray.isEmpty(array);
    }

    public static boolean isNotEmpty(Object array) {
        return !RsArray.isEmpty(array);
    }

    public static <T> boolean hasNull(T ... array) {
        if (RsArray.isNotEmpty(array)) {
            for (T element : array) {
                if (!RsObject.isNull(element)) continue;
                return true;
            }
        }
        return array == null;
    }

    public static <T> T firstMatch(Predicate<T> matcher, T ... array) {
        int index = RsArray.matchIndex(matcher, array);
        if (index == -1) {
            return null;
        }
        return array[index];
    }

    public static <T> int matchIndex(Predicate<T> matcher, T ... array) {
        return RsArray.matchIndex(0, matcher, array);
    }

    public static <E> int matchIndex(int beginIndexInclude, Predicate<E> matcher, E ... array) {
        if (RsArray.isEmpty(array)) {
            return -1;
        }
        ArrayWrapper<E[], E> arrayWrapper = ArrayWrapper.of(array);
        return arrayWrapper.matchIndex(beginIndexInclude, matcher);
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Class<?> getComponentType(Object array) {
        return null == array ? null : RsArray.getComponentType(array.getClass());
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (RsArray.isEmpty(buffer)) {
            return newElements;
        }
        return RsArray.insert(buffer, buffer.length, newElements);
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (!RsArray.isNotEmpty(array)) continue;
            length += array.length;
        }
        T[] result = RsArray.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        if (length == 0) {
            return result;
        }
        length = 0;
        for (T[] array : arrays) {
            if (!RsArray.isNotEmpty(array)) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return RsArray.insert(buffer, index, newElements);
    }

    @SafeVarargs
    public static <A, T> A insert(A array, int index, T ... newElements) {
        return ArrayWrapper.of(array).insert(index, newElements).getRaw();
    }

    public static <T> T copy(Object src, T dest, int length) {
        return RsArray.copy(src, 0, dest, 0, length);
    }

    public static <T> T copy(Object src, int srcPos, T dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (RsArray.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                RsArray.copy(obj, result, length);
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T[] edit(T[] array, UnaryOperator<T> editor) {
        if (null == array || null == editor) {
            return array;
        }
        ArrayList list = new ArrayList(array.length);
        for (T t : array) {
            Object modified = editor.apply(t);
            if (null == modified) continue;
            list.add(modified);
        }
        T[] result = RsArray.newArray(array.getClass().getComponentType(), list.size());
        return list.toArray(result);
    }

    public static <T> T[] filter(T[] array, Predicate<T> predicate) {
        if (null == array || null == predicate) {
            return array;
        }
        return RsArray.edit(array, t -> predicate.test(t) ? t : null);
    }

    public static <T> int indexOf(T[] array, Object value) {
        return ArrayWrapper.of(array).indexOf(value);
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        if (RsArray.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (!RsString.equals(array[i], value, true)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        return RsArray.indexOf(array, value) > -1;
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return RsArray.indexOfIgnoreCase(array, value) > -1;
    }

    public static Object[] wrap(Object obj) {
        if (null == obj) {
            return null;
        }
        if (RsArray.isArray(obj)) {
            try {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return RsArray.wrap((long[])obj);
                    }
                    case "int": {
                        return RsArray.wrap((int[])obj);
                    }
                    case "short": {
                        return RsArray.wrap((short[])obj);
                    }
                    case "char": {
                        return RsArray.wrap((char[])obj);
                    }
                    case "byte": {
                        return RsArray.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return RsArray.wrap((boolean[])obj);
                    }
                    case "float": {
                        return RsArray.wrap((float[])obj);
                    }
                    case "double": {
                        return RsArray.wrap((double[])obj);
                    }
                }
                return (Object[])obj;
            }
            catch (Exception e) {
                throw RsExceptionHandle.wrapRuntime(e);
            }
        }
        throw new RsException(RsString.format("[{}] is not Array!", obj.getClass()));
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static <E> E get(Object array, int index) {
        return ArrayWrapper.of(array).get(index);
    }

    public static <E> E get(E[] array, Predicate<E> predicate) {
        for (E e : array) {
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    public static String toString(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (RsArray.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return RsArray.join(array, conjunction, null, null);
    }

    public static <T> String join(T[] array, CharSequence delimiter, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        return StringJoiner.of(delimiter, prefix, suffix).setWrapElement(true).append(array).toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        if (!RsArray.isArray(array)) {
            throw new IllegalArgumentException(RsString.format("[{}] is not a Array!", array.getClass()));
        }
        return StringJoiner.of(conjunction).append(array).toString();
    }

    public static <T, R> R[] map(Object array, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        int length = RsArray.length(array);
        T[] result = RsArray.newArray(targetComponentType, length);
        for (int i = 0; i < length; ++i) {
            result[i] = func.apply(RsArray.get(array, i));
        }
        return result;
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (RsArray.hasNull(array1, array2)) {
            return false;
        }
        Assert.isTrue(RsArray.isArray(array1), "First is not a Array !", new Object[0]);
        Assert.isTrue(RsArray.isArray(array2), "Second is not a Array !", new Object[0]);
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])array1, (Object[])array2);
    }
}

