/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.HashMap;
import java.util.Map;
import top.redscorpion.core.enums.ErrorCode;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.vo.Result;

public class R {
    private R() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> Result<T> success() {
        Result result = new Result();
        result.setSuccess(true);
        result.setCode(ErrorCode.SUCCESS.getCode());
        result.setMessage(ErrorCode.SUCCESS.getMessage());
        return result;
    }

    public static <T> Result<T> success(String message) {
        Result result = new Result();
        result.setSuccess(true);
        result.setCode(ErrorCode.SUCCESS.getCode());
        result.setMessage(message);
        return result;
    }

    public static <T> Result<T> data(T t) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(ErrorCode.SUCCESS.getCode());
        result.setMessage(ErrorCode.SUCCESS.getMessage());
        result.setData(t);
        return result;
    }

    public static <T> Result<T> data(T t, String message) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(ErrorCode.SUCCESS.getCode());
        result.setMessage(message);
        result.setData(t);
        return result;
    }

    public static <T> Result<T> error() {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode(ErrorCode.UNKNOWN.getCode());
        result.setMessage(ErrorCode.UNKNOWN.getMessage());
        return result;
    }

    public static <T> Result<T> error(String message) {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode("-1");
        result.setMessage(message);
        return result;
    }

    public static <T> Result<T> error(String code, String message) {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode(code);
        result.setMessage(message);
        return result;
    }

    public static Map<String, Object> errorMap(String code, String message) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("success", false);
        resultMap.put("code", code);
        resultMap.put("message", message);
        resultMap.put("timestamp", System.currentTimeMillis());
        return resultMap;
    }

    public static <T> Result<T> error(ErrorCode errorCode) {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode(errorCode.getCode());
        result.setMessage(errorCode.getMessage());
        return result;
    }

    public static <T> Result<T> error(ErrorCode errorCode, String message) {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode(errorCode.getCode());
        result.setMessage(message);
        return result;
    }

    public static <T> Result<T> successLog(String path, String name, String message) {
        RsFile.logOut(path, name, message);
        return R.success(message);
    }

    public static <T> Result<T> dataLog(T t, String path, String name, String message) {
        RsFile.logOut(path, name, message);
        return R.data(t, message);
    }

    public static <T> Result<T> errorLog(String path, String name, String message) {
        RsFile.logOut(path, name, message);
        return R.error(message);
    }

    public static <T> Result<T> errorLog(String code, String path, String name, String message) {
        RsFile.logOut(path, name, message);
        return R.error(code, message);
    }
}

