/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text.replacer;

import top.redscorpion.core.text.replacer.AbstractStringReplacer;
import top.redscorpion.core.util.RsString;

public class RangeReplacerByChar
extends AbstractStringReplacer {
    private static final long serialVersionUID = 1L;
    private final int beginInclude;
    private final int endExclude;
    private final char replacedChar;

    public RangeReplacerByChar(int beginInclude, int endExclude, char replacedChar) {
        this.beginInclude = beginInclude;
        this.endExclude = endExclude;
        this.replacedChar = replacedChar;
    }

    @Override
    public String apply(CharSequence str) {
        if (RsString.isEmpty(str)) {
            return RsString.str(str);
        }
        int beginInclude = this.beginInclude;
        String originalStr = RsString.str(str);
        int[] strCodePoints = originalStr.codePoints().toArray();
        int strLength = strCodePoints.length;
        if (beginInclude > strLength) {
            return originalStr;
        }
        int endExclude = this.endExclude;
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (beginInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder(originalStr.length());
        for (int i = 0; i < strLength; ++i) {
            if (i >= beginInclude && i < endExclude) {
                this.replace(originalStr, i, stringBuilder);
                continue;
            }
            stringBuilder.appendCodePoint(strCodePoints[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected int replace(CharSequence str, int pos, StringBuilder out) {
        out.appendCodePoint(this.replacedChar);
        return pos;
    }
}

