/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import top.redscorpion.core.bean.NullWrapperBean;
import top.redscorpion.core.collection.set.UniqueKeySet;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.WeakConcurrentMap;
import top.redscorpion.core.reflect.method.RsMethodHandle;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsBoolean;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsString;

public class RsMethod {
    private static final WeakConcurrentMap<Class<?>, Method[]> METHODS_CACHE = new WeakConcurrentMap();

    public static Method[] getPublicMethods(Class<?> clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static Method[] getPublicMethods(Class<?> clazz, Predicate<Method> predicate) {
        if (null == clazz) {
            return null;
        }
        Method[] methods = RsMethod.getPublicMethods(clazz);
        if (null == predicate) {
            return methods;
        }
        return RsArray.filter(methods, predicate);
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || RsString.isBlank(methodName)) {
            return null;
        }
        return RsMethod.getMethod(obj.getClass(), methodName, RsClass.getClasses(args));
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return RsMethod.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || RsString.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        Method[] methods = RsMethod.getMethods(clazz);
        if (RsArray.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!RsString.equals(methodName, method.getName(), ignoreCase) || !RsClass.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return RsMethod.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || RsString.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        Method[] methods = RsMethod.getMethods(clazz);
        if (RsArray.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!RsString.equals(methodName, method.getName(), ignoreCase) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return METHODS_CACHE.computeIfAbsent(beanClass, key -> RsMethod.getMethodsDirectly(beanClass, true, true));
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        Assert.notNull(beanClass);
        if (beanClass.isInterface()) {
            return withSupers ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        }
        UniqueKeySet<String, Method> result = new UniqueKeySet<String, Method>(true, RsMethod::getUniqueKey);
        Class<?> searchType = beanClass;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            result.addAllIfAbsent(Arrays.asList(searchType.getDeclaredMethods()));
            result.addAllIfAbsent(RsMethod.getDefaultMethodsFromInterface(searchType));
            searchType = withSupers && !searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return result.toArray(new Method[0]);
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return RsMethod.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        int parameterCount = method.getParameterCount();
        switch (parameterCount) {
            case 0: {
                return RsMethod.isGetter(method, ignoreCase);
            }
            case 1: {
                return RsMethod.isSetter(method, ignoreCase);
            }
        }
        return false;
    }

    public static boolean isSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (1 != parameterCount) {
            return false;
        }
        String name = method.getName();
        if ("set".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        return name.startsWith("set");
    }

    public static boolean isGetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (0 != parameterCount) {
            return false;
        }
        String name = method.getName();
        if ("getClass".equals(name) || "get".equals(name) || "is".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        if (name.startsWith("is")) {
            return RsBoolean.isBoolean(method.getReturnType());
        }
        return name.startsWith("get");
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws RsException {
        return RsMethod.invoke(null, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws RsException {
        try {
            return RsMethodHandle.invoke(obj, method, args);
        }
        catch (Exception e) {
            try {
                return (T)method.invoke(RsModifier.isStatic(method) ? null : obj, RsMethod.actualArgs(method, args));
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RsException(ex);
            }
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws RsException {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = RsMethod.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new RsException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        return RsMethod.invoke(obj, method, args);
    }

    public static Object[] actualArgs(Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (1 == parameterTypes.length && parameterTypes[0].isArray()) {
            return args;
        }
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = RsClass.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (args[i] instanceof NullWrapperBean) {
                    actualArgs[i] = null;
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = RsConvert.convert(parameterTypes[i], args[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        return actualArgs;
    }

    private static String getUniqueKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append('#');
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method m : ifc.getMethods()) {
                if (RsModifier.isAbstract(m)) continue;
                result.add(m);
            }
        }
        return result;
    }
}

