/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net.url;

import java.io.Serializable;
import java.nio.charset.Charset;
import top.redscorpion.core.io.stream.FastByteArrayOutputStream;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsCharset;

public class UrlDecoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte ESCAPE_CHAR = 37;

    public static String decodeForPath(String str, Charset charset) {
        return UrlDecoder.decode(str, charset, false);
    }

    public static String decode(String str, Charset charset, boolean isPlusToSpace) {
        if (null == charset) {
            return str;
        }
        if (null == str) {
            return null;
        }
        int length = str.length();
        if (0 == length) {
            return "";
        }
        StringBuilder result = new StringBuilder(length / 3);
        int begin = 0;
        for (int i = 0; i < length; ++i) {
            int c = str.charAt(i);
            if (37 == c || RsChar.isHexChar((char)c)) continue;
            if (i > begin) {
                result.append(UrlDecoder.decodeSub(str, begin, i, charset, isPlusToSpace));
            }
            if (43 == c && isPlusToSpace) {
                c = 32;
            }
            result.append((char)c);
            begin = i + 1;
        }
        if (begin < length) {
            result.append(UrlDecoder.decodeSub(str, begin, length, charset, isPlusToSpace));
        }
        return result.toString();
    }

    public static byte[] decode(byte[] bytes, boolean isPlusToSpace) {
        if (bytes == null) {
            return null;
        }
        FastByteArrayOutputStream buffer = new FastByteArrayOutputStream(bytes.length / 3);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b == 43) {
                buffer.write(isPlusToSpace ? 32 : b);
                continue;
            }
            if (b == 37) {
                int l;
                int u;
                if (i + 1 < bytes.length && (u = RsChar.digit16(bytes[i + 1])) >= 0 && i + 2 < bytes.length && (l = RsChar.digit16(bytes[i + 2])) >= 0) {
                    buffer.write((char)((u << 4) + l));
                    i += 2;
                    continue;
                }
                buffer.write(b);
                continue;
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    private static String decodeSub(String str, int begin, int end, Charset charset, boolean isPlusToSpace) {
        return new String(UrlDecoder.decode(str.substring(begin, end).getBytes(RsCharset.ISO_8859_1), isPlusToSpace), charset);
    }
}

