/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.math;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import top.redscorpion.core.util.RsString;

public class NumberParser {
    public static final NumberParser INSTANCE = NumberParser.of(null);
    private static final String NAN = "NaN";
    private final Locale locale;
    private final boolean zeroIfNaN;

    public static NumberParser of(Locale locale) {
        return NumberParser.of(locale, true);
    }

    public static NumberParser of(Locale locale, boolean zeroIfNaN) {
        return new NumberParser(locale, zeroIfNaN);
    }

    public NumberParser(Locale locale, boolean zeroIfNaN) {
        this.locale = locale;
        this.zeroIfNaN = zeroIfNaN;
    }

    public int parseInt(String numberStr) throws NumberFormatException {
        if (this.isBlankOrNaN(numberStr)) {
            return 0;
        }
        if (RsString.startWith(numberStr, "0x", true)) {
            return Integer.parseInt(numberStr.substring(2), 16);
        }
        if (RsString.containsIgnoreCase(numberStr, "E")) {
            throw new NumberFormatException(RsString.format("Unsupported int format: [{}]", numberStr));
        }
        try {
            return Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            return this.doParse(numberStr).intValue();
        }
    }

    public long parseLong(String numberStr) {
        if (this.isBlankOrNaN(numberStr)) {
            return 0L;
        }
        if (RsString.startWith(numberStr, "0x", true)) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        try {
            return Long.parseLong(numberStr);
        }
        catch (NumberFormatException e) {
            return this.doParse(numberStr).longValue();
        }
    }

    public float parseFloat(String numberStr) {
        if (this.isBlankOrNaN(numberStr)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(numberStr);
        }
        catch (NumberFormatException e) {
            return this.doParse(numberStr).floatValue();
        }
    }

    public double parseDouble(String numberStr) {
        if (this.isBlankOrNaN(numberStr)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(numberStr);
        }
        catch (NumberFormatException e) {
            return this.doParse(numberStr).doubleValue();
        }
    }

    public BigInteger parseBigInteger(String str) {
        if (null == (str = RsString.trimToNull(str))) {
            return null;
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        if (pos > 0) {
            str = str.substring(pos);
        }
        BigInteger value = new BigInteger(str, radix);
        return negate ? value.negate() : value;
    }

    public Number parseNumber(String numberStr) throws NumberFormatException {
        if (this.isBlankOrNaN(numberStr)) {
            return 0;
        }
        if (RsString.startWith(numberStr, "0x", true)) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        return this.doParse(numberStr);
    }

    private Number doParse(String numberStr) {
        Locale locale = this.locale;
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        if (RsString.startWith((CharSequence)numberStr, '+')) {
            numberStr = RsString.subSuf(numberStr, 1);
        }
        try {
            NumberFormat format = NumberFormat.getInstance(locale);
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            return format.parse(numberStr);
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause(e);
            throw nfe;
        }
    }

    private boolean isBlankOrNaN(String numberStr) throws NumberFormatException {
        if (RsString.isBlank(numberStr)) {
            return true;
        }
        if (NAN.equals(numberStr)) {
            if (this.zeroIfNaN) {
                return true;
            }
            throw new NumberFormatException("Can not parse NaN when 'zeroIfNaN' is false!");
        }
        return false;
    }
}

