/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang.getter;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import top.redscorpion.core.convert.CompositeConverter;
import top.redscorpion.core.convert.Converter;

public interface TypeGetter<K> {
    public Object getObj(K var1, Object var2);

    default public Object getObj(K key) {
        return this.getObj(key, null);
    }

    default public <T> T get(K key, Type type) {
        return this.get(key, type, null);
    }

    default public <T> T get(K key, Type type, T defaultValue) {
        return this.get(key, type, CompositeConverter.getInstance(), defaultValue);
    }

    default public <T> T get(K key, Type type, Converter converter, T defaultValue) {
        return converter.convert(type, this.getObj(key), defaultValue);
    }

    default public String getStr(K key, String defaultValue) {
        return this.get(key, (Type)((Object)String.class), (Object)defaultValue);
    }

    default public String getStr(K key) {
        return this.getStr(key, null);
    }

    default public Integer getInt(K key, Integer defaultValue) {
        return this.get(key, (Type)((Object)Integer.class), (Object)defaultValue);
    }

    default public Integer getInt(K key) {
        return this.getInt(key, null);
    }

    default public Short getShort(K key, Short defaultValue) {
        return this.get(key, (Type)((Object)Short.class), (Object)defaultValue);
    }

    default public Short getShort(K key) {
        return this.getShort(key, null);
    }

    default public Boolean getBool(K key, Boolean defaultValue) {
        return this.get(key, (Type)((Object)Boolean.class), (Object)defaultValue);
    }

    default public Boolean getBool(K key) {
        return this.getBool(key, null);
    }

    default public Long getLong(K key, Long defaultValue) {
        return this.get(key, (Type)((Object)Long.class), (Object)defaultValue);
    }

    default public Long getLong(K key) {
        return this.getLong(key, null);
    }

    default public Character getChar(K key, Character defaultValue) {
        return this.get(key, (Type)((Object)Character.class), (Object)defaultValue);
    }

    default public Character getChar(K key) {
        return this.getChar(key, null);
    }

    default public Float getFloat(K key, Float defaultValue) {
        return this.get(key, (Type)((Object)Float.class), (Object)defaultValue);
    }

    default public Float getFloat(K key) {
        return this.getFloat(key, null);
    }

    default public Double getDouble(K key, Double defaultValue) {
        return this.get(key, (Type)((Object)Double.class), (Object)defaultValue);
    }

    default public Double getDouble(K key) {
        return this.getDouble(key, null);
    }

    default public Byte getByte(K key, Byte defaultValue) {
        return this.get(key, (Type)((Object)Byte.class), (Object)defaultValue);
    }

    default public Byte getByte(K key) {
        return this.getByte(key, null);
    }

    default public byte[] getBytes(K key, byte[] defaultValue) {
        return this.get(key, (Type)((Object)byte[].class), (Object)defaultValue);
    }

    default public byte[] getBytes(K key) {
        return this.getBytes(key, null);
    }

    default public BigDecimal getBigDecimal(K key, BigDecimal defaultValue) {
        return this.get(key, (Type)((Object)BigDecimal.class), (Object)defaultValue);
    }

    default public BigDecimal getBigDecimal(K key) {
        return this.getBigDecimal(key, null);
    }

    default public BigInteger getBigInteger(K key, BigInteger defaultValue) {
        return this.get(key, (Type)((Object)BigInteger.class), (Object)defaultValue);
    }

    default public BigInteger getBigInteger(K key) {
        return this.getBigInteger(key, null);
    }

    default public <E extends Enum<E>> E getEnum(Class<E> clazz, K key, E defaultValue) {
        return this.get(key, clazz, defaultValue);
    }

    default public <E extends Enum<E>> E getEnum(Class<E> clazz, K key) {
        return this.getEnum(clazz, key, null);
    }

    default public Number getNumber(K key, Number defaultValue) {
        return this.get(key, (Type)((Object)Number.class), (Object)defaultValue);
    }

    default public Number getNumber(K key) {
        return this.getNumber(key, null);
    }

    default public Date getDate(K key, Date defaultValue) {
        return this.get(key, (Type)((Object)Date.class), (Object)defaultValue);
    }

    default public Date getDate(K key) {
        return this.getDate(key, null);
    }

    default public Time getSqlTime(K key, Time defaultValue) {
        return this.get(key, (Type)((Object)Time.class), (Object)defaultValue);
    }

    default public Time getSqlTime(K key) {
        return this.getSqlTime(key, null);
    }

    default public Timestamp getSqlTimestamp(K key, Timestamp defaultValue) {
        return this.get(key, (Type)((Object)Timestamp.class), (Object)defaultValue);
    }

    default public Timestamp getSqlTimestamp(K key) {
        return this.getSqlTimestamp(key, null);
    }

    default public LocalDateTime getLocalDateTime(K key, LocalDateTime defaultValue) {
        return this.get(key, (Type)((Object)LocalDateTime.class), (Object)defaultValue);
    }

    default public LocalDateTime getLocalDateTime(K key) {
        return this.getLocalDateTime(key, null);
    }

    default public LocalDate getLocalDate(K key, LocalDate defaultValue) {
        return this.get(key, (Type)((Object)LocalDate.class), (Object)defaultValue);
    }

    default public LocalDate getLocalDate(K key) {
        return this.getLocalDate(key, null);
    }

    default public LocalTime getLocalTime(K key, LocalTime defaultValue) {
        return this.get(key, (Type)((Object)LocalTime.class), (Object)defaultValue);
    }

    default public LocalTime getLocalTime(K key) {
        return this.getLocalTime(key, null);
    }
}

