/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.file.visitor.DelVisitor;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsPath;

public class PathDeleter {
    private final Path path;

    public static PathDeleter of(Path src) {
        return new PathDeleter(src);
    }

    public PathDeleter(Path path) {
        this.path = Assert.notNull(path, "Path must be not null !", new Object[0]);
    }

    public void del() throws IORuntimeException {
        Path path = this.path;
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        if (RsPath.isDirectory(path)) {
            PathDeleter.theDel(path);
        } else {
            PathDeleter.delFile(path);
        }
    }

    private static void theDel(Path path) {
        try {
            Files.walkFileTree(path, DelVisitor.INSTANCE);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static void delFile(Path path) throws IORuntimeException {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            if (e instanceof AccessDeniedException && path.toFile().delete()) {
                return;
            }
            throw new IORuntimeException(e);
        }
    }
}

