/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format.parser;

import top.redscorpion.core.date.DateException;
import top.redscorpion.core.date.DatePattern;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.format.DefaultDateBasic;
import top.redscorpion.core.date.format.parser.PredicateDateParser;
import top.redscorpion.core.util.RsNumber;

public class PureDateParser
extends DefaultDateBasic
implements PredicateDateParser {
    private static final long serialVersionUID = 1L;
    public static PureDateParser INSTANCE = new PureDateParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return RsNumber.isNumber(dateStr);
    }

    @Override
    public DateTime parse(String source) throws DateException {
        int length = source.length();
        if (length == "yyyyMMddHHmmss".length()) {
            return new DateTime((CharSequence)source, DatePattern.PURE_DATETIME_FORMAT);
        }
        if (length == "yyyyMMddHHmmssSSS".length()) {
            return new DateTime((CharSequence)source, DatePattern.PURE_DATETIME_MS_FORMAT);
        }
        if (length == "yyyyMMdd".length()) {
            return new DateTime((CharSequence)source, DatePattern.PURE_DATE_FORMAT);
        }
        if (length == "HHmmss".length()) {
            return new DateTime((CharSequence)source, DatePattern.PURE_TIME_FORMAT);
        }
        if (length >= 11 && length <= 13) {
            return new DateTime(RsNumber.parseLong(source));
        }
        throw new DateException("No pure format fit for date String [{}] !", source);
    }
}

