/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format.parser;

import java.util.regex.Pattern;
import top.redscorpion.core.date.DateException;
import top.redscorpion.core.date.DatePattern;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.format.DefaultDateBasic;
import top.redscorpion.core.date.format.parser.PredicateDateParser;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;

public class NormalDateParser
extends DefaultDateBasic
implements PredicateDateParser {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN_NORM = Pattern.compile("\\d{4}-\\d{1,2}-\\d{1,2}(\\s\\d{1,2}:\\d{1,2}(:\\d{1,2})?(.\\d{1,6})?)?");
    public static NormalDateParser INSTANCE = new NormalDateParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return RsRegular.isMatch(PATTERN_NORM, dateStr);
    }

    @Override
    public DateTime parse(String source) throws DateException {
        int colonCount = RsString.count(source, ':');
        switch (colonCount) {
            case 0: {
                return new DateTime((CharSequence)source, DatePattern.NORM_DATE_FORMAT);
            }
            case 1: {
                return new DateTime((CharSequence)source, DatePattern.NORM_DATETIME_MINUTE_FORMAT);
            }
            case 2: {
                int indexOfDot = RsString.indexOf((CharSequence)source, '.');
                if (indexOfDot > 0) {
                    int length1 = source.length();
                    if (length1 - indexOfDot > 4) {
                        source = RsString.subPre(source, indexOfDot + 4);
                    }
                    return new DateTime((CharSequence)source, DatePattern.NORM_DATETIME_MS_FORMAT);
                }
                return new DateTime((CharSequence)source, DatePattern.NORM_DATETIME_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", source);
    }
}

