/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.CompositeConverter;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class ReferenceConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static ReferenceConverter INSTANCE = new ReferenceConverter();

    @Override
    protected Reference<?> convertInternal(Class<?> targetClass, Object value) {
        Object targetValue = null;
        Type paramType = RsType.getTypeArgument(targetClass);
        if (!RsType.isUnknown(paramType)) {
            targetValue = CompositeConverter.getInstance().convert(paramType, value);
        }
        if (null == targetValue) {
            targetValue = value;
        }
        if (targetClass == WeakReference.class) {
            return new WeakReference<Object>(targetValue);
        }
        if (targetClass == SoftReference.class) {
            return new SoftReference<Object>(targetValue);
        }
        throw new UnsupportedOperationException(RsString.format("Unsupport Reference type: {}", targetClass.getName()));
    }
}

