/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.bean.copier.AbstractCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.mutable.MutableEntry;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsType;

public class BeanToBeanCopier<S, T>
extends AbstractCopier<S, T> {
    private final Type targetType;

    public BeanToBeanCopier(S source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = RsBean.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        Map<String, PropDesc> sourcePropDescMap = RsBean.getBeanDesc(this.source.getClass()).getPropMap(this.copyOptions.ignoreCase);
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(this.copyOptions.transientSupport)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source);
            if (!this.copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            MutableEntry<String, Object> entry = this.copyOptions.editField((String)sFieldName, sValue);
            if (null == entry) {
                return;
            }
            sFieldName = entry.getKey();
            if (null == sFieldName) {
                return;
            }
            sValue = entry.getValue();
            PropDesc tDesc = this.copyOptions.findPropDesc(targetPropDescMap, (String)sFieldName);
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = RsType.getActualType(this.targetType, tDesc.getFieldType());
            sValue = this.copyOptions.convertField(fieldType, sValue);
            tDesc.setValue(this.target, sValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

