/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.CaseInsensitiveMap;
import top.redscorpion.core.reflect.RsField;
import top.redscorpion.core.reflect.method.RsMethod;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsBoolean;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsRecord;
import top.redscorpion.core.util.RsString;

public class BeanDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Map<String, PropDesc> propMap = new LinkedHashMap<String, PropDesc>();

    public BeanDesc(Class<?> beanClass) {
        Assert.notNull(beanClass);
        this.beanClass = beanClass;
        this.init();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Map<String, PropDesc> getPropMap(boolean ignoreCase) {
        return ignoreCase ? new CaseInsensitiveMap<String, PropDesc>(1.0f, this.propMap) : this.propMap;
    }

    public Collection<PropDesc> getProps() {
        return this.propMap.values();
    }

    public PropDesc getProp(String fieldName) {
        return this.propMap.get(fieldName);
    }

    public Field getField(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getField();
    }

    public Method getGetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getGetter();
    }

    public Method getSetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getSetter();
    }

    private void init() {
        if (RsRecord.isRecord(this.beanClass)) {
            this.initForRecord();
        } else {
            this.initForBean();
        }
    }

    private void initForRecord() {
        Method[] getters = RsMethod.getPublicMethods(this.beanClass, method -> 0 == method.getParameterCount());
        for (Field field : RsField.getFields(this.beanClass)) {
            if (RsModifier.isStatic(field) || RsField.isOuterClassField(field)) continue;
            for (Method getter : getters) {
                if (!field.getName().equals(getter.getName())) continue;
                PropDesc prop = new PropDesc(field, getter, null);
                this.propMap.putIfAbsent(prop.getFieldName(), prop);
            }
        }
    }

    private void initForBean() {
        Method[] gettersAndSetters = RsMethod.getPublicMethods(this.beanClass, RsMethod::isGetterOrSetterIgnoreCase);
        for (Field field : RsField.getFields(this.beanClass)) {
            if (RsModifier.isStatic(field) || RsField.isOuterClassField(field)) continue;
            PropDesc prop = this.createProp(field, gettersAndSetters);
            this.propMap.putIfAbsent(prop.getFieldName(), prop);
        }
    }

    private PropDesc createProp(Field field, Method[] methods) {
        PropDesc prop = this.findProp(field, methods, false);
        if (null == prop.getter || null == prop.setter) {
            PropDesc propIgnoreCase = this.findProp(field, methods, true);
            if (null == prop.getter) {
                prop.getter = propIgnoreCase.getter;
            }
            if (null == prop.setter) {
                prop.setter = propIgnoreCase.setter;
            }
        }
        return prop;
    }

    private PropDesc findProp(Field field, Method[] gettersOrSetters, boolean ignoreCase) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooleanField = RsBoolean.isBoolean(fieldType);
        Method[] getterAndSetter = this.findGetterAndSetter(fieldName, fieldType, gettersOrSetters, ignoreCase);
        if (isBooleanField) {
            if (null == getterAndSetter[0]) {
                getterAndSetter[0] = this.findGetterForBoolean(fieldName, gettersOrSetters, ignoreCase);
            }
            if (null == getterAndSetter[1]) {
                getterAndSetter[1] = this.findSetterForBoolean(fieldName, gettersOrSetters, ignoreCase);
            }
        }
        return new PropDesc(field, getterAndSetter[0], getterAndSetter[1]);
    }

    private Method[] findGetterAndSetter(String fieldName, Class<?> fieldType, Method[] gettersOrSetters, boolean ignoreCase) {
        Method getter = null;
        Method setter = null;
        for (Method method : gettersOrSetters) {
            String methodName = method.getName();
            if (0 == method.getParameterCount()) {
                if (RsString.equals(methodName, RsString.genGetter(fieldName), ignoreCase) && method.getReturnType().isAssignableFrom(fieldType)) {
                    getter = method;
                }
            } else if (RsString.equals(methodName, RsString.genSetter(fieldName), ignoreCase) && fieldType.isAssignableFrom(method.getParameterTypes()[0])) {
                setter = method;
            }
            if (null != getter && null != setter) break;
        }
        return new Method[]{getter, setter};
    }

    private Method findGetterForBoolean(String fieldName, Method[] gettersOrSetters, boolean ignoreCase) {
        return RsArray.get(gettersOrSetters, m -> {
            if (0 != m.getParameterCount() || !RsBoolean.isBoolean(m.getReturnType())) {
                return false;
            }
            if (RsString.startWith(fieldName, "is", ignoreCase) && RsString.equals(fieldName, m.getName(), ignoreCase)) {
                return true;
            }
            return RsString.equals(RsString.upperFirstAndAddPre(fieldName, "is"), m.getName(), ignoreCase);
        });
    }

    private Method findSetterForBoolean(String fieldName, Method[] gettersOrSetters, boolean ignoreCase) {
        return RsArray.get(gettersOrSetters, m -> {
            if (1 != m.getParameterCount() || !RsBoolean.isBoolean(m.getParameterTypes()[0])) {
                return false;
            }
            if (RsString.startWith(fieldName, "is", ignoreCase)) {
                return RsString.equals("set" + RsString.removePrefix(fieldName, "is", ignoreCase), m.getName(), ignoreCase);
            }
            return false;
        });
    }
}

