/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.array;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.function.Predicate;
import top.redscorpion.core.collection.iter.ArrayIter;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.wrapper.Wrapper;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsObject;

public class ArrayWrapper<A, E>
implements Wrapper<A>,
Iterable<E> {
    private final Class<E> componentType;
    private A array;
    private int length;

    public static <A, E> ArrayWrapper<A, E> of(A array) {
        return new ArrayWrapper<A, E>(array);
    }

    public ArrayWrapper(A array) {
        Assert.notNull(array, "Array must be not null!", new Object[0]);
        if (!RsArray.isArray(array)) {
            throw new IllegalArgumentException("Object is not a array!");
        }
        this.componentType = array.getClass().getComponentType();
        this.setNewArray(array);
    }

    @Override
    public A getRaw() {
        return this.array;
    }

    public boolean isEmpty() {
        return 0 == this.length;
    }

    public E get(int index) {
        int length = this.length;
        if (index < 0) {
            index += length;
        }
        if (index < 0 || index >= length) {
            return null;
        }
        return (E)Array.get(this.array, index);
    }

    public int indexOf(Object value) {
        return this.matchIndex(obj -> RsObject.equals(value, obj));
    }

    public int matchIndex(Predicate<E> matcher) {
        return this.matchIndex(0, matcher);
    }

    public int matchIndex(int offset, Predicate<E> matcher) {
        if (null == matcher && offset < this.length) {
            return offset;
        }
        for (int i = offset; i < this.length; ++i) {
            if (!matcher.test(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    public ArrayWrapper<A, E> insert(int index, E element) {
        return this.insertArray(index, RsArray.ofArray(element, this.componentType));
    }

    public ArrayWrapper<A, E> insertArray(int index, A arrayToInsert) {
        int appendLength = RsArray.length(arrayToInsert);
        if (0 == appendLength) {
            return this;
        }
        if (this.isEmpty()) {
            this.setNewArray(RsConvert.convert(this.array.getClass(), arrayToInsert));
            return this;
        }
        int len = this.length;
        if (index < 0) {
            index = index % len + len;
        }
        if (this.componentType.isPrimitive()) {
            arrayToInsert = RsConvert.convert(this.array.getClass(), arrayToInsert);
        }
        Object result = Array.newInstance(this.componentType, Math.max(len, index) + appendLength);
        System.arraycopy(this.array, 0, result, 0, Math.min(len, index));
        System.arraycopy(arrayToInsert, 0, result, index, appendLength);
        if (index < len) {
            System.arraycopy(this.array, index, result, index + appendLength, len - index);
        }
        this.setNewArray(result);
        return this;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIter(this.array);
    }

    public String toString() {
        return RsArray.toString(this.array);
    }

    private void setNewArray(A newArray) {
        this.array = newArray;
        this.length = Array.getLength(newArray);
    }
}

