/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.template.engine;

import top.redscorpion.core.lang.Singleton;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.util.RsSpi;
import top.redscorpion.core.util.RsString;
import top.redscorpion.log.RsLog;
import top.redscorpion.template.TemplateConfig;
import top.redscorpion.template.TemplateException;
import top.redscorpion.template.engine.TemplateEngine;

public class TemplateEngineFactory {
    public static TemplateEngine getEngine() {
        TemplateEngine engine = Singleton.get(TemplateEngine.class.getName(), TemplateEngineFactory::createEngine);
        RsLog.debug("Use [{}] Template Engine As Default.", RsString.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    public static TemplateEngine createEngine() {
        return TemplateEngineFactory.createEngine(TemplateConfig.DEFAULT);
    }

    public static TemplateEngine createEngine(TemplateConfig config) {
        return TemplateEngineFactory.doCreateEngine(config);
    }

    private static TemplateEngine doCreateEngine(TemplateConfig config) {
        Class<? extends TemplateEngine> customEngineClass = config.getCustomEngine();
        TemplateEngine engine = null != customEngineClass ? RsConstructor.newInstance(customEngineClass, new Object[0]) : RsSpi.loadFirstAvailable(TemplateEngine.class);
        if (null != engine) {
            return engine.init(config);
        }
        throw new TemplateException("No template found! Please add one of template jar to your project !");
    }
}

