/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsIter;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.excel.reader.AbstractSheetReader;

public class MapSheetReader
extends AbstractSheetReader<List<Map<String, Object>>> {
    private final int headerRowIndex;

    public MapSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex) {
        super(startRowIndex, endRowIndex);
        this.headerRowIndex = headerRowIndex;
    }

    @Override
    public List<Map<String, Object>> read(Sheet sheet) {
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum < 0) {
            return RsList.empty();
        }
        if (this.headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(RsString.format("Header row index {} is lower than first row index {}.", this.headerRowIndex, firstRowNum));
        }
        if (this.headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(RsString.format("Header row index {} is greater than last row index {}.", this.headerRowIndex, lastRowNum));
        }
        if (this.startRowIndex > lastRowNum) {
            return RsList.empty();
        }
        int startRowIndex = Math.max(this.startRowIndex, firstRowNum);
        int endRowIndex = Math.min(this.endRowIndex, lastRowNum);
        List<String> headerList = this.aliasHeader(this.readRow(sheet, this.headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == this.headerRowIndex || !RsColl.isNotEmpty(rowList = this.readRow(sheet, i)) && this.ignoreEmptyRow) continue;
            result.add(RsIter.toMap(headerList, rowList, true));
        }
        return result;
    }
}

