/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.okhttp;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import okhttp3.Headers;
import okhttp3.ResponseBody;
import top.redscorpion.core.io.stream.EmptyInputStream;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.GlobalCompressStreamRegister;
import top.redscorpion.http.RsHttp;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.meta.HeaderName;

public class OkHttpResponse
implements Response {
    private final okhttp3.Response rawRes;
    private final Charset requestCharset;

    public OkHttpResponse(okhttp3.Response rawRes, Charset requestCharset) {
        this.rawRes = rawRes;
        this.requestCharset = requestCharset;
    }

    @Override
    public int getStatus() {
        return this.rawRes.code();
    }

    @Override
    public String header(String name) {
        return this.rawRes.header(name);
    }

    @Override
    public Map<String, List<String>> headers() {
        Headers headers = this.rawRes.headers();
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(headers.size(), 1.0f);
        for (Pair header : headers) {
            List valueList = result.computeIfAbsent((String)header.getFirst(), k -> new ArrayList());
            valueList.add(header.getSecond());
        }
        return result;
    }

    @Override
    public Charset charset() {
        return RsObject.defaultIfNull(Response.super.charset(), this.requestCharset);
    }

    @Override
    public InputStream bodyStream() {
        ResponseBody body = this.rawRes.body();
        if (null == body) {
            return EmptyInputStream.INSTANCE;
        }
        return GlobalCompressStreamRegister.INSTANCE.wrapStream(body.byteStream(), this.rawRes.header(HeaderName.CONTENT_ENCODING.getValue()));
    }

    @Override
    public void close() {
        if (null != this.rawRes) {
            this.rawRes.close();
        }
    }

    public String toString() {
        return RsHttp.toString(this);
    }
}

