/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.multi.ListValueMap;
import top.redscorpion.core.net.url.UrlBuilder;
import top.redscorpion.core.net.url.UrlQuery;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.GlobalHeaders;
import top.redscorpion.http.HttpGlobalConfig;
import top.redscorpion.http.client.HeaderOperation;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.AbstractFormBody;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.body.StringBody;
import top.redscorpion.http.client.body.UrlEncodedFormBody;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.http.client.engine.ClientEngineFactory;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.meta.Method;

public class Request
implements HeaderOperation<Request> {
    private static final Charset DEFAULT_CHARSET = RsCharset.UTF_8;
    private Method method = Method.GET;
    private UrlBuilder url;
    private final ListValueMap<String, String> headers = new ListValueMap(new LinkedHashMap());
    private HttpBody body;
    private int maxRedirectCount = HttpGlobalConfig.getMaxRedirectCount();
    private boolean isRest;

    public static Request of(String url) {
        return Request.of(url, HttpGlobalConfig.isDecodeUrl() ? DEFAULT_CHARSET : null);
    }

    public static Request of(String url, Charset charset) {
        return Request.of(UrlBuilder.ofHttp(url, charset));
    }

    public static Request of(UrlBuilder url) {
        return new Request().url(url);
    }

    public Request() {
        this.header(GlobalHeaders.INSTANCE.headers(), false);
    }

    public Method method() {
        return this.method;
    }

    public Request method(Method method) {
        this.method = method;
        return this;
    }

    public UrlBuilder url() {
        return this.url;
    }

    public UrlBuilder handledUrl() {
        return this.urlWithParamIfGet();
    }

    public Request url(UrlBuilder url) {
        this.url = url;
        return this;
    }

    public Request charset(Charset charset) {
        Assert.notNull(this.url, "You must be set request url first.", new Object[0]);
        this.url.setCharset(charset);
        return this;
    }

    public Charset charset() {
        Assert.notNull(this.url, "You must be set request url first.", new Object[0]);
        return RsObject.defaultIfNull(this.url.getCharset(), DEFAULT_CHARSET);
    }

    @Override
    public Map<String, ? extends Collection<String>> headers() {
        return RsMap.view(this.headers);
    }

    public boolean isChunked() {
        String transferEncoding = this.header(HeaderName.TRANSFER_ENCODING);
        return "Chunked".equalsIgnoreCase(transferEncoding);
    }

    @Override
    public Request header(String name, String value, boolean isOverride) {
        if (null == name) {
            return this;
        }
        if (null == value) {
            this.headers.remove(name);
            return this;
        }
        if (isOverride) {
            this.headers.put(name.trim(), (String)((Object)RsList.of(value)));
        } else {
            this.headers.putValue(name.trim(), value);
        }
        return this;
    }

    public HttpBody body() {
        return this.body;
    }

    public HttpBody handledBody() {
        if (Method.GET.equals((Object)this.method) && !this.isRest) {
            return null;
        }
        return this.body();
    }

    public Request form(Map<String, Object> formMap) {
        return this.body(new UrlEncodedFormBody(formMap, this.charset()));
    }

    public Request body(String body) {
        return this.body(new StringBody(body, this.charset()));
    }

    public Request body(HttpBody body) {
        this.body = body;
        if (RsString.isBlank(this.header(HeaderName.CONTENT_TYPE))) {
            this.header(HeaderName.CONTENT_TYPE, body.getContentType(this.charset()), true);
        }
        return this;
    }

    public int maxRedirectCount() {
        return this.maxRedirectCount;
    }

    public Request setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = Math.max(maxRedirectCount, 0);
        return this;
    }

    public Request setRest(boolean isRest) {
        this.isRest = isRest;
        return this;
    }

    public Response send() {
        return this.send(ClientEngineFactory.getEngine());
    }

    public Response send(ClientEngine engine) {
        return engine.send(this);
    }

    private UrlBuilder urlWithParamIfGet() {
        HttpBody body;
        if (Method.GET.equals((Object)this.method) && !this.isRest && (body = this.body) instanceof AbstractFormBody) {
            UrlBuilder urlBuilder = UrlBuilder.of(this.url);
            UrlQuery query = urlBuilder.getQuery();
            if (null == query) {
                query = UrlQuery.of();
                urlBuilder.setQuery(query);
            }
            query.addAll(((AbstractFormBody)body).form());
            return urlBuilder;
        }
        return this.url();
    }
}

