/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsUrlQuery;
import top.redscorpion.http.HttpGlobalConfig;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.http.client.engine.ClientEngineFactory;
import top.redscorpion.http.meta.Method;
import top.redscorpion.http.server.SimpleServer;

public class RsHttp {
    public static boolean isHttps(String url) {
        return RsString.startWith(url, "https:", true);
    }

    public static boolean isHttp(String url) {
        return RsString.startWith(url, "http:", true);
    }

    public static String get(String urlString, Charset customCharset) {
        return RsHttp.send(Request.of(urlString).charset(customCharset)).bodyStr();
    }

    public static String get(String urlString) {
        return RsHttp.get(urlString, HttpGlobalConfig.getTimeout());
    }

    public static String get(String urlString, int timeout) {
        return ClientEngineFactory.getEngine().init(ClientConfig.of().setConnectionTimeout(timeout).setReadTimeout(timeout)).send(Request.of(urlString)).bodyStr();
    }

    public static String get(String urlString, Map<String, Object> paramMap) {
        return RsHttp.send(Request.of(urlString).form(paramMap)).bodyStr();
    }

    public static String post(String urlString, Map<String, Object> paramMap) {
        return RsHttp.send(Request.of(urlString).method(Method.POST).form(paramMap)).bodyStr();
    }

    public static String post(String urlString, String body) {
        return RsHttp.send(Request.of(urlString).method(Method.POST).body(body)).bodyStr();
    }

    public static Response send(Request request) {
        return ClientEngineFactory.getEngine().send(request);
    }

    public static String urlWithFormUrlEncoded(String url, Map<String, Object> form, Charset charset) {
        return RsHttp.urlWithForm(url, form, charset, true);
    }

    public static String urlWithForm(String url, Map<String, Object> form, Charset charset, boolean isEncodeParams) {
        return RsHttp.urlWithForm(url, RsUrlQuery.toQuery(form, charset), charset, isEncodeParams);
    }

    public static String urlWithForm(String url, String queryString, Charset charset, boolean isEncode) {
        if (RsString.isBlank(queryString)) {
            if (RsString.contains((CharSequence)url, '?')) {
                return isEncode ? RsUrlQuery.encodeQuery(url, charset) : url;
            }
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder(url.length() + queryString.length() + 16);
        int qmIndex = url.indexOf(63);
        if (qmIndex > 0) {
            urlBuilder.append(isEncode ? RsUrlQuery.encodeQuery(url, charset) : url);
            if (!RsString.endWith((CharSequence)url, '&')) {
                urlBuilder.append('&');
            }
        } else {
            urlBuilder.append(url);
            if (qmIndex < 0) {
                urlBuilder.append('?');
            }
        }
        urlBuilder.append(isEncode ? RsUrlQuery.encodeQuery(queryString, charset) : queryString);
        return urlBuilder.toString();
    }

    public static ClientEngine createClient(String engineName) {
        return ClientEngineFactory.createEngine(engineName);
    }

    public static SimpleServer createServer(int port) {
        return new SimpleServer(port);
    }

    public static String toString(Response response) {
        StringBuilder sb = new StringBuilder();
        sb.append("Response Status: ").append(response.getStatus()).append("\r\n");
        sb.append("Response Headers: ").append("\r\n");
        for (Map.Entry<String, List<String>> entry : response.headers().entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Response Body: ").append("\r\n");
        sb.append("    ").append(response.bodyStr()).append("\r\n");
        return sb.toString();
    }

    public static String get(Request request) {
        return RsHttp.send(request).bodyStr();
    }

    public static String post(Request request) {
        return RsHttp.send(request.method(Method.POST)).bodyStr();
    }
}

