/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.extra.mail;

import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.extra.mail.Mail;
import top.redscorpion.extra.mail.MailAccount;

public class RsMail {
    public static String send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, RsMail.splitAddress(to), subject, content, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, tos, null, null, subject, content, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, false, tos, ccs, bccs, subject, content, null, isHtml, files);
    }

    public static String send(MailAccount mailAccount, String to, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, RsMail.splitAddress(to), subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, tos, null, null, subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return RsMail.send(mailAccount, false, tos, ccs, bccs, subject, content, imageMap, isHtml, files);
    }

    public static Session getSession(final MailAccount mailAccount, boolean isSingleton) {
        Authenticator authenticator = null;
        if (mailAccount.isAuth().booleanValue()) {
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(mailAccount.getUser(), String.valueOf(mailAccount.getPass()));
                }
            };
        }
        return isSingleton ? Session.getDefaultInstance((Properties)mailAccount.getSmtpProps(), (Authenticator)authenticator) : Session.getInstance((Properties)mailAccount.getSmtpProps(), (Authenticator)authenticator);
    }

    private static String send(MailAccount mailAccount, boolean useGlobalSession, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        Mail mail = Mail.of(mailAccount).setUseGlobalSession(useGlobalSession);
        if (RsColl.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[0]));
        }
        if (RsColl.isNotEmpty(bccs)) {
            mail.setBccs(bccs.toArray(new String[0]));
        }
        mail.setTos(tos.toArray(new String[0]));
        mail.setTitle(subject);
        mail.setContent(content);
        mail.setHtml(isHtml);
        mail.setFiles(files);
        if (RsMap.isNotEmpty(imageMap)) {
            for (Map.Entry<String, InputStream> entry : imageMap.entrySet()) {
                mail.addImage(entry.getKey(), entry.getValue());
                RsIo.closeQuietly(entry.getValue());
            }
        }
        return mail.send();
    }

    private static List<String> splitAddress(String addresses) {
        if (RsString.isBlank(addresses)) {
            return null;
        }
        List<String> result = RsString.contains((CharSequence)addresses, ',') ? RsSplit.splitTrim(addresses, ",") : (RsString.contains((CharSequence)addresses, ';') ? RsSplit.splitTrim(addresses, ";") : RsList.of(addresses));
        return result;
    }
}

