/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.text.CharSequenceHandle;
import top.redscorpion.core.text.finder.AbstractTextFinder;
import top.redscorpion.core.text.finder.CharFinder;
import top.redscorpion.core.text.finder.StringFinder;
import top.redscorpion.core.text.split.SplitIter;

public class RsSplit {
    public static final int UNLIMITED = -1;

    public static List<String> splitTrim(CharSequence str, CharSequence separator) {
        return RsSplit.split(str, separator, true, true);
    }

    public static String[] splitToArray(CharSequence str, CharSequence separator) {
        if (str == null) {
            return new String[0];
        }
        return RsSplit.toArray(RsSplit.split(str, separator));
    }

    public static List<String> split(CharSequence str, CharSequence separator) {
        return RsSplit.split(str, separator, false, false);
    }

    public static List<String> split(CharSequence str, CharSequence separator, boolean isTrim, boolean ignoreEmpty) {
        return RsSplit.split(str, separator, -1, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return RsSplit.split(str, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> split(CharSequence str, CharSequence separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        return RsSplit.split(str, separator, limit, ignoreEmpty, ignoreCase, RsSplit.trimFunc(isTrim));
    }

    public static <R> List<R> split(CharSequence str, CharSequence separator, int limit, boolean ignoreEmpty, boolean ignoreCase, Function<String, R> mapping) {
        if (null == str) {
            return new ArrayList(0);
        }
        if (0 == str.length() && ignoreEmpty) {
            return new ArrayList(0);
        }
        Assert.notEmpty(separator, "Separator must be not empty!", new Object[0]);
        AbstractTextFinder finder = separator.length() == 1 ? new CharFinder(separator.charAt(0), ignoreCase) : StringFinder.of(separator, ignoreCase);
        SplitIter splitIter = new SplitIter(str, finder, limit, ignoreEmpty);
        return splitIter.toList(mapping);
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    public static Function<String, String> trimFunc(boolean isTrim) {
        return isTrim ? CharSequenceHandle::trim : Function.identity();
    }
}

