/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.file.PathCopier;
import top.redscorpion.core.io.file.PathDeleter;
import top.redscorpion.core.io.file.PathMover;

public class RsPath {
    public static void del(Path path) throws IORuntimeException {
        PathDeleter.of(path).del();
    }

    public static Path copy(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        return PathCopier.of(src, target, options).copy();
    }

    public static boolean isDirectory(Path path) {
        return RsPath.isDirectory(path, false);
    }

    public static boolean isDirectory(Path path, boolean isFollowLinks) {
        if (null == path) {
            return false;
        }
        return Files.isDirectory(path, RsPath.getLinkOptions(isFollowLinks));
    }

    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Path rename(Path path, String newName, boolean isOverride) {
        return RsPath.move(path, path.resolveSibling(newName), isOverride);
    }

    public static Path move(Path src, Path target, boolean isOverride) {
        return PathMover.of(src, target, isOverride).move();
    }

    public static boolean equals(Path file1, Path file2) throws IORuntimeException {
        try {
            return Files.isSameFile(file1, file2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean exists(Path path, boolean isFollowLinks) {
        if (null == path) {
            return false;
        }
        return Files.exists(path, RsPath.getLinkOptions(isFollowLinks));
    }

    public static boolean isSub(Path parent, Path sub) {
        return RsPath.toAbsNormal(sub).startsWith(RsPath.toAbsNormal(parent));
    }

    public static Path toAbsNormal(Path path) {
        if (null == path) {
            return null;
        }
        return path.toAbsolutePath().normalize();
    }

    public static String getMimeType(Path file) {
        try {
            return Files.probeContentType(file);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public static Path mkdir(Path dir) {
        if (null != dir && !RsPath.exists(dir, false)) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return dir;
    }

    public static Path mkParentDirs(Path path) {
        return RsPath.mkdir(path.getParent());
    }

    public static Path createTempFile(String prefix, String suffix, Path dir) throws IORuntimeException {
        int exceptionsCount = 0;
        while (true) {
            try {
                if (null == dir) {
                    return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
                }
                return Files.createTempFile(RsPath.mkdir(dir), prefix, suffix, new FileAttribute[0]);
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new IORuntimeException(ioex);
            }
            break;
        }
    }

    public static LinkOption[] getLinkOptions(boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        return linkOptionArray;
    }
}

