/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import top.redscorpion.core.math.NumberParser;
import top.redscorpion.core.math.NumberValidator;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsCompare;
import top.redscorpion.core.util.RsString;

public class RsNumber
extends NumberValidator {
    public static BigDecimal sub(Number ... values) {
        if (RsArray.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = RsNumber.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(RsNumber.toBigDecimal(value));
        }
        return result;
    }

    public static boolean equals(Number number1, Number number2) {
        if (number1 instanceof BigDecimal && number2 instanceof BigDecimal) {
            return RsCompare.equals((BigDecimal)number1, (BigDecimal)number2);
        }
        return Objects.equals(number1, number2);
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return RsNumber.toBigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String numberStr) {
        if (RsString.isBlank(numberStr)) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(numberStr);
        }
        catch (Exception exception) {
            return RsNumber.toBigDecimal(RsNumber.parseNumber(numberStr));
        }
    }

    public static BigInteger toBigInteger(String number) {
        return RsString.isBlank(number) ? BigInteger.ZERO : new BigInteger(number);
    }

    public static int parseInt(String numberStr) throws NumberFormatException {
        return NumberParser.INSTANCE.parseInt(numberStr);
    }

    public static long parseLong(String numberStr) {
        return NumberParser.INSTANCE.parseLong(numberStr);
    }

    public static float parseFloat(String numberStr) {
        return NumberParser.INSTANCE.parseFloat(numberStr);
    }

    public static double parseDouble(String numberStr) {
        return NumberParser.INSTANCE.parseDouble(numberStr);
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        return NumberParser.INSTANCE.parseNumber(numberStr);
    }

    public static double toDouble(Number value) {
        if (value instanceof Float) {
            return Double.parseDouble(value.toString());
        }
        return value.doubleValue();
    }
}

