/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import top.redscorpion.core.data.id.Snowflake;
import top.redscorpion.core.data.id.UUID;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.Singleton;
import top.redscorpion.core.util.RsIpv4;
import top.redscorpion.core.util.RsRuntime;

public class RsId {
    public static String uuid() {
        return UUID.randomUuid().toString(true);
    }

    public static String uuid(boolean isSimple) {
        return UUID.randomUuid().toString(isSimple);
    }

    public static String fastUuid() {
        return UUID.fastUuid().toString(true);
    }

    public static String fastUuid(boolean isSimple) {
        return UUID.fastUuid().toString(isSimple);
    }

    public static Snowflake getSnowflake(long workerId, long datacenterId) {
        return Singleton.get(Snowflake.class, workerId, datacenterId);
    }

    public static Snowflake getSnowflake(long workerId) {
        return Singleton.get(Snowflake.class, workerId);
    }

    public static Snowflake getSnowflake() {
        return Singleton.get(Snowflake.class, new Object[0]);
    }

    public static long getDataCenterId(long maxDatacenterId) {
        Assert.isTrue(maxDatacenterId > 0L, "maxDatacenterId must be > 0", new Object[0]);
        if (maxDatacenterId == Long.MAX_VALUE) {
            --maxDatacenterId;
        }
        long id = 1L;
        byte[] mac = null;
        try {
            mac = RsIpv4.getLocalHardwareAddress();
        }
        catch (RsException rsException) {
            // empty catch block
        }
        if (null != mac) {
            id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
            id %= maxDatacenterId + 1L;
        }
        return id;
    }

    public static long getWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        try {
            mpid.append(RsRuntime.getPid());
        }
        catch (RsException rsException) {
            // empty catch block
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public static long snowflakeNextId() {
        return RsId.getSnowflake().next();
    }

    public static String snowflakeNextIdStr() {
        return RsId.getSnowflake().nextStr();
    }

    public static long nextId() {
        return RsId.getSnowflake().next();
    }

    public static String nextIdStr() {
        return RsId.getSnowflake().nextStr();
    }
}

