/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.util.RsCaller;
import top.redscorpion.core.util.RsClassDesc;

public class RsClassLoader {
    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = RsCaller.getCallerCaller().getClassLoader();
        if (null == classLoader) {
            classLoader = RsClassLoader.getContextClassLoader();
        }
        if (classLoader == null && null == (classLoader = RsClassLoader.class.getClassLoader())) {
            classLoader = RsClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static <T> Class<T> loadClass(String name) throws RsException {
        return RsClassLoader.loadClass(name, true);
    }

    public static <T> Class<T> loadClass(String name, boolean isInitialized) throws RsException {
        return RsClassLoader.loadClass(name, isInitialized, null);
    }

    public static <T> Class<T> loadClass(String name, boolean isInitialized, ClassLoader classLoader) throws RsException {
        return RsClassDesc.nameToClass(name, isInitialized, classLoader);
    }
}

