/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text.split;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import top.redscorpion.core.collection.iter.AbstractComputeIter;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.text.finder.AbstractTextFinder;
import top.redscorpion.core.util.RsString;

public class SplitIter
extends AbstractComputeIter<String>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String text;
    private final AbstractTextFinder finder;
    private final int limit;
    private final boolean ignoreEmpty;
    private int offset;
    private int count;

    public SplitIter(CharSequence text, AbstractTextFinder separatorFinder, int limit, boolean ignoreEmpty) {
        Assert.notNull(text, "Text must be not null!", new Object[0]);
        this.text = text.toString();
        this.finder = separatorFinder.setText(text);
        this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
        this.ignoreEmpty = ignoreEmpty;
    }

    @Override
    protected String computeNext() {
        if (this.count >= this.limit || this.offset > this.text.length()) {
            return null;
        }
        if (this.count == this.limit - 1) {
            if (this.ignoreEmpty && this.offset == this.text.length()) {
                return null;
            }
            ++this.count;
            return this.text.substring(this.offset);
        }
        int start = this.finder.start(this.offset);
        if (start < 0) {
            if (this.offset <= this.text.length()) {
                String result = this.text.substring(this.offset);
                if (!this.ignoreEmpty || !result.isEmpty()) {
                    this.offset = Integer.MAX_VALUE;
                    return result;
                }
            }
            return null;
        }
        String result = this.text.substring(this.offset, start);
        this.offset = this.finder.end(start);
        if (this.ignoreEmpty && result.isEmpty()) {
            return this.computeNext();
        }
        ++this.count;
        return result;
    }

    public <T> List<T> toList(Function<String, T> mapping) {
        ArrayList<T> result = new ArrayList<T>();
        while (this.hasNext()) {
            T apply = mapping.apply((String)this.next());
            if (this.ignoreEmpty && RsString.isEmptyIfStr(apply)) continue;
            result.add(apply);
        }
        if (result.isEmpty()) {
            return new ArrayList(0);
        }
        return result;
    }
}

