/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text.replacer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import top.redscorpion.core.text.replacer.AbstractStringReplacer;

public class LookupReplacer
extends AbstractStringReplacer {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> lookupMap;
    private final Set<Character> keyPrefixSkeyet;
    private final int minLength;
    private final int maxLength;

    public LookupReplacer(String[] ... lookup) {
        this.lookupMap = new HashMap<String, String>(lookup.length, 1.0f);
        this.keyPrefixSkeyet = new HashSet<Character>(lookup.length, 1.0f);
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        for (String[] pair : lookup) {
            String key = pair[0];
            this.lookupMap.put(key, pair[1]);
            this.keyPrefixSkeyet.add(Character.valueOf(key.charAt(0)));
            int keySize = key.length();
            if (keySize > maxLength) {
                maxLength = keySize;
            }
            if (keySize >= minLength) continue;
            minLength = keySize;
        }
        this.maxLength = maxLength;
        this.minLength = minLength;
    }

    @Override
    protected int replace(CharSequence str, int pos, StringBuilder out) {
        if (this.keyPrefixSkeyet.contains(Character.valueOf(str.charAt(pos)))) {
            int max = this.maxLength;
            if (pos + this.maxLength > str.length()) {
                max = str.length() - pos;
            }
            for (int i = max; i >= this.minLength; --i) {
                CharSequence subSeq = str.subSequence(pos, pos + i);
                String result = this.lookupMap.get(subSeq.toString());
                if (null == result) continue;
                out.append(result);
                return i;
            }
        }
        return 0;
    }
}

