/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text.placeholder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.text.placeholder.segment.AbstractPlaceholderSegment;
import top.redscorpion.core.text.placeholder.segment.LiteralSegment;
import top.redscorpion.core.text.placeholder.segment.StringTemplateSegment;
import top.redscorpion.core.text.placeholder.template.NamedPlaceholderStringTemplate;
import top.redscorpion.core.text.placeholder.template.SinglePlaceholderStringTemplate;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsString;

public abstract class AbstractStringTemplate {
    public static final char DEFAULT_ESCAPE = '\\';
    protected static int globalFeatures = Feature.of(Feature.FORMAT_MISSING_KEY_PRINT_WHOLE_PLACEHOLDER, Feature.FORMAT_NULL_VALUE_TO_STR, Feature.MATCH_KEEP_DEFAULT_VALUE, Feature.MATCH_EMPTY_VALUE_TO_NULL, Feature.MATCH_NULL_STR_TO_NULL);
    protected static UnaryOperator<String> globalDefaultValueHandler;
    private final String template;
    protected final char escape;
    protected final String defaultValue;
    protected final UnaryOperator<String> defaultValueHandler;
    private final int features;
    protected List<StringTemplateSegment> segments;
    protected List<AbstractPlaceholderSegment> placeholderSegments;
    protected int fixedTextTotalLength;

    public static SinglePlaceholderStringTemplate.Builder of(String template) {
        return SinglePlaceholderStringTemplate.builder(template);
    }

    public static NamedPlaceholderStringTemplate.Builder ofNamed(String template) {
        return NamedPlaceholderStringTemplate.builder(template);
    }

    public static void setGlobalFeatures(Feature ... globalFeatures) {
        AbstractStringTemplate.globalFeatures = Feature.of(globalFeatures);
    }

    public static void setGlobalDefaultValue(UnaryOperator<String> globalDefaultValueHandler) {
        AbstractStringTemplate.globalDefaultValueHandler = Objects.requireNonNull(globalDefaultValueHandler);
    }

    protected AbstractStringTemplate(String template, char escape, String defaultValue, UnaryOperator<String> defaultValueHandler, int features) {
        Assert.notNull(template, "String template cannot be null", new Object[0]);
        this.template = template;
        this.escape = escape;
        this.defaultValue = defaultValue;
        this.defaultValueHandler = defaultValueHandler;
        this.features = features;
    }

    public String getTemplate() {
        return this.template;
    }

    public int getFeatures() {
        return this.features;
    }

    public boolean isMatches(String str) {
        if (RsString.isEmpty(str)) {
            return false;
        }
        int startIdx = 0;
        boolean hasPlaceholder = false;
        for (StringTemplateSegment segment : this.segments) {
            if (segment instanceof LiteralSegment) {
                String text = segment.getText();
                int findIdx = str.indexOf(text, startIdx);
                if (findIdx == -1) {
                    return false;
                }
                if (findIdx != startIdx && !hasPlaceholder) {
                    return false;
                }
                startIdx = findIdx + text.length();
                hasPlaceholder = false;
                continue;
            }
            if (hasPlaceholder) {
                throw new RsException("There are two closely related placeholders that cannot be split properly!");
            }
            hasPlaceholder = true;
        }
        return true;
    }

    public List<String> getPlaceholderVariableNames() {
        return this.placeholderSegments.stream().map(AbstractPlaceholderSegment::getPlaceholder).collect(Collectors.toList());
    }

    public List<String> getPlaceholderTexts() {
        return this.placeholderSegments.stream().map(AbstractPlaceholderSegment::getText).collect(Collectors.toList());
    }

    public String formatRawByKey(Function<String, String> valueSupplier) {
        return this.formatRawBySegment(segment -> (String)valueSupplier.apply(segment.getPlaceholder()));
    }

    public String formatRawBySegment(Function<AbstractPlaceholderSegment, String> valueSupplier) {
        ArrayList<String> values = new ArrayList<String>(this.placeholderSegments.size());
        int totalTextLength = this.fixedTextTotalLength;
        for (AbstractPlaceholderSegment segment : this.placeholderSegments) {
            String valueStr = valueSupplier.apply(segment);
            if (valueStr == null) {
                valueStr = "null";
            }
            totalTextLength += valueStr.length();
            values.add(valueStr);
        }
        StringBuilder sb = new StringBuilder(totalTextLength);
        int index = 0;
        for (StringTemplateSegment segment : this.segments) {
            if (segment instanceof LiteralSegment) {
                sb.append(segment.getText());
                continue;
            }
            sb.append((String)values.get(index++));
        }
        return sb.toString();
    }

    protected String formatSequence(Iterable<?> iterable) {
        if (iterable == null) {
            return this.getTemplate();
        }
        Iterator<?> iterator = iterable.iterator();
        return this.formatBySegment(segment -> {
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return this.formatMissingKey((AbstractPlaceholderSegment)segment);
        });
    }

    protected String formatBySegment(Function<AbstractPlaceholderSegment, ?> valueSupplier) {
        return this.formatRawBySegment(segment -> {
            Object value = valueSupplier.apply((AbstractPlaceholderSegment)segment);
            if (value != null) {
                if (value instanceof String) {
                    return (String)value;
                }
                return RsString.utf8Str(value);
            }
            return this.formatNullValue((AbstractPlaceholderSegment)segment);
        });
    }

    protected String formatMissingKey(AbstractPlaceholderSegment segment) {
        int features = this.getFeatures();
        if (Feature.FORMAT_MISSING_KEY_PRINT_WHOLE_PLACEHOLDER.contains(features)) {
            return segment.getText();
        }
        if (Feature.FORMAT_MISSING_KEY_PRINT_DEFAULT_VALUE.contains(features)) {
            return this.getDefaultValue(segment);
        }
        if (Feature.FORMAT_MISSING_KEY_PRINT_NULL.contains(features)) {
            return "null";
        }
        if (Feature.FORMAT_MISSING_KEY_PRINT_EMPTY.contains(features)) {
            return "";
        }
        if (Feature.FORMAT_MISSING_KEY_PRINT_VARIABLE_NAME.contains(features)) {
            return segment.getPlaceholder();
        }
        if (Feature.FORMAT_MISSING_KEY_THROWS.contains(features)) {
            throw new RsException("There is no value associated with key: '" + segment.getPlaceholder() + "'");
        }
        throw new RsException("There is no value associated with key: '" + segment.getPlaceholder() + "'. You should define some Feature for missing key when building.");
    }

    protected String formatNullValue(AbstractPlaceholderSegment segment) {
        int features = this.getFeatures();
        if (Feature.FORMAT_NULL_VALUE_TO_STR.contains(features)) {
            return "null";
        }
        if (Feature.FORMAT_NULL_VALUE_TO_EMPTY.contains(features)) {
            return "";
        }
        if (Feature.FORMAT_NULL_VALUE_TO_WHOLE_PLACEHOLDER.contains(features)) {
            return segment.getText();
        }
        if (Feature.FORMAT_NULL_VALUE_TO_DEFAULT_VALUE.contains(features)) {
            return this.getDefaultValue(segment);
        }
        throw new RsException("There is a NULL value cannot resolve. You should define a Feature for null value when building or filter null value.");
    }

    public void matchesRawByKey(String str, BiConsumer<String, String> keyValueConsumer) {
        if (str == null || keyValueConsumer == null || RsColl.isEmpty(this.placeholderSegments)) {
            return;
        }
        this.matchesRawBySegment(str, (segment, value) -> keyValueConsumer.accept(segment.getPlaceholder(), (String)value));
    }

    public void matchesRawBySegment(String str, BiConsumer<AbstractPlaceholderSegment, String> keyValueConsumer) {
        if (str == null || keyValueConsumer == null || RsColl.isEmpty(this.placeholderSegments)) {
            return;
        }
        int startIdx = 0;
        AbstractPlaceholderSegment placeholderSegment = null;
        for (StringTemplateSegment segment : this.segments) {
            if (segment instanceof LiteralSegment) {
                String text = segment.getText();
                int findIdx = str.indexOf(text, startIdx);
                if (findIdx == -1) {
                    return;
                }
                if (placeholderSegment != null) {
                    keyValueConsumer.accept(placeholderSegment, str.substring(startIdx, findIdx));
                } else if (findIdx != startIdx) {
                    return;
                }
                startIdx = findIdx + text.length();
                placeholderSegment = null;
                continue;
            }
            if (placeholderSegment != null) {
                throw new RsException("There are two closely related placeholders that cannot be split properly!");
            }
            placeholderSegment = (AbstractPlaceholderSegment)segment;
        }
        if (placeholderSegment != null) {
            keyValueConsumer.accept(placeholderSegment, str.substring(startIdx));
        }
    }

    protected List<String> matchesSequence(String str) {
        if (str == null || this.placeholderSegments.isEmpty() || !this.isMatches(str)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> list = new ArrayList<String>(this.placeholderSegments.size());
        this.matchesByKey(str, (segment, value) -> list.add((String)value));
        return list;
    }

    public void matchesByKey(String str, BiConsumer<String, String> keyValueConsumer) {
        if (this.hasDefaultValue()) {
            this.matchesByKey(str, keyValueConsumer, true, this::getDefaultValue);
        } else {
            this.matchesByKey(str, keyValueConsumer, false, null);
        }
    }

    protected void matchesByKey(String str, BiConsumer<String, String> keyValueConsumer, boolean hasDefaultValue, Function<AbstractPlaceholderSegment, String> defaultValueSupplier) {
        if (str == null || keyValueConsumer == null || RsColl.isEmpty(this.placeholderSegments)) {
            return;
        }
        this.matchesRawBySegment(str, (segment, value) -> this.matchByKey(keyValueConsumer, segment.getPlaceholder(), (String)value, hasDefaultValue, () -> hasDefaultValue ? RsString.utf8Str(defaultValueSupplier.apply((AbstractPlaceholderSegment)segment)) : null));
    }

    private void matchByKey(BiConsumer<String, String> keyValueConsumer, String key, String value, boolean hasDefaultValue, Supplier<String> defaultValueSupplier) {
        int features = this.getFeatures();
        if (hasDefaultValue && !Feature.MATCH_KEEP_DEFAULT_VALUE.contains(features) && value.equals(defaultValueSupplier.get())) {
            if (Feature.MATCH_IGNORE_DEFAULT_VALUE.contains(features)) {
                return;
            }
            if (Feature.MATCH_DEFAULT_VALUE_TO_NULL.contains(features)) {
                keyValueConsumer.accept(key, null);
                return;
            }
        }
        if ("".equals(value)) {
            if (Feature.MATCH_EMPTY_VALUE_TO_NULL.contains(features)) {
                keyValueConsumer.accept(key, null);
            } else if (Feature.MATCH_EMPTY_VALUE_TO_DEFAULT_VALUE.contains(features)) {
                keyValueConsumer.accept(key, defaultValueSupplier.get());
            } else {
                if (Feature.MATCH_IGNORE_EMPTY_VALUE.contains(features)) {
                    return;
                }
                if (Feature.MATCH_KEEP_VALUE_EMPTY.contains(features)) {
                    keyValueConsumer.accept(key, value);
                }
            }
            return;
        }
        if ("null".equals(value)) {
            if (Feature.MATCH_NULL_STR_TO_NULL.contains(features)) {
                keyValueConsumer.accept(key, null);
            } else if (Feature.MATCH_KEEP_NULL_STR.contains(features)) {
                keyValueConsumer.accept(key, value);
            } else if (Feature.MATCH_IGNORE_NULL_STR.contains(features)) {
                return;
            }
            return;
        }
        keyValueConsumer.accept(key, value);
    }

    protected boolean hasDefaultValue() {
        return this.defaultValue != null || this.defaultValueHandler != null || globalDefaultValueHandler != null;
    }

    protected String getDefaultValue(AbstractPlaceholderSegment segment) {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        if (this.defaultValueHandler != null) {
            return RsString.utf8Str(this.defaultValueHandler.apply(segment.getPlaceholder()));
        }
        if (globalDefaultValueHandler != null) {
            return RsString.utf8Str(globalDefaultValueHandler.apply(segment.getPlaceholder()));
        }
        throw new RsException("There is no default value for key: '" + segment.getPlaceholder() + "'. You should define a 'defaultValue' or 'defaultValueHandler' or 'globalDefaultValueHandler' when building.");
    }

    protected void afterInit() {
        this.segments = new ArrayList<StringTemplateSegment>(this.parseSegments(this.template));
        int literalSegmentSize = 0;
        int fixedTextTotalLength = 0;
        for (StringTemplateSegment segment : this.segments) {
            if (!(segment instanceof LiteralSegment)) continue;
            ++literalSegmentSize;
            fixedTextTotalLength += segment.getText().length();
        }
        this.fixedTextTotalLength = fixedTextTotalLength;
        int placeholderSegmentsSize = this.segments.size() - literalSegmentSize;
        if (placeholderSegmentsSize == 0) {
            this.placeholderSegments = Collections.emptyList();
        } else {
            ArrayList<AbstractPlaceholderSegment> placeholderSegments = new ArrayList<AbstractPlaceholderSegment>(placeholderSegmentsSize);
            for (StringTemplateSegment segment : this.segments) {
                if (!(segment instanceof AbstractPlaceholderSegment)) continue;
                placeholderSegments.add((AbstractPlaceholderSegment)segment);
            }
            this.placeholderSegments = placeholderSegments;
        }
    }

    protected void addLiteralSegment(boolean isLastLiteralSegment, List<StringTemplateSegment> list, String newText) {
        if (newText.isEmpty()) {
            return;
        }
        if (isLastLiteralSegment) {
            int lastIdx = list.size() - 1;
            StringTemplateSegment lastLiteralSegment = list.get(lastIdx);
            list.set(lastIdx, new LiteralSegment(lastLiteralSegment.getText() + newText));
        } else {
            list.add(new LiteralSegment(newText));
        }
    }

    protected abstract List<StringTemplateSegment> parseSegments(String var1);

    protected List<StringTemplateSegment> getSegments() {
        return this.segments;
    }

    protected List<AbstractPlaceholderSegment> getPlaceholderSegments() {
        return this.placeholderSegments;
    }

    public static enum Feature {
        FORMAT_MISSING_KEY_PRINT_WHOLE_PLACEHOLDER(0, 0, 6),
        FORMAT_MISSING_KEY_PRINT_DEFAULT_VALUE(1, 0, 6),
        FORMAT_MISSING_KEY_PRINT_NULL(2, 0, 6),
        FORMAT_MISSING_KEY_PRINT_EMPTY(3, 0, 6),
        FORMAT_MISSING_KEY_PRINT_VARIABLE_NAME(4, 0, 6),
        FORMAT_MISSING_KEY_THROWS(5, 0, 6),
        FORMAT_NULL_VALUE_TO_STR(6, 6, 4),
        FORMAT_NULL_VALUE_TO_EMPTY(7, 6, 4),
        FORMAT_NULL_VALUE_TO_WHOLE_PLACEHOLDER(8, 6, 4),
        FORMAT_NULL_VALUE_TO_DEFAULT_VALUE(9, 6, 4),
        MATCH_KEEP_DEFAULT_VALUE(16, 16, 3),
        MATCH_IGNORE_DEFAULT_VALUE(17, 16, 3),
        MATCH_DEFAULT_VALUE_TO_NULL(18, 16, 3),
        MATCH_EMPTY_VALUE_TO_NULL(19, 19, 4),
        MATCH_EMPTY_VALUE_TO_DEFAULT_VALUE(20, 19, 4),
        MATCH_IGNORE_EMPTY_VALUE(21, 19, 4),
        MATCH_KEEP_VALUE_EMPTY(22, 19, 4),
        MATCH_NULL_STR_TO_NULL(23, 23, 3),
        MATCH_KEEP_NULL_STR(24, 23, 3),
        MATCH_IGNORE_NULL_STR(25, 23, 3);

        private final int mask;
        private final int clearMask;

        private Feature(int bitPos, int bitStart, int bitLen) {
            this.mask = 1 << bitPos;
            this.clearMask = -1 << bitStart + bitLen | (1 << bitStart) - 1;
        }

        public boolean contains(int features) {
            return (features & this.mask) != 0;
        }

        public int set(int features) {
            return features & this.clearMask | this.mask;
        }

        public int clear(int features) {
            return features & this.clearMask;
        }

        public static int of(Feature ... features) {
            if (features == null) {
                return 0;
            }
            int value = 0;
            for (Feature feature : features) {
                value = feature.set(value);
            }
            return value;
        }
    }

    protected static abstract class AbstractBuilder<BuilderChild extends AbstractBuilder<BuilderChild, TemplateChild>, TemplateChild extends AbstractStringTemplate> {
        protected final String template;
        protected String defaultValue;
        protected UnaryOperator<String> defaultValueHandler;
        protected boolean escape$set;
        protected char escape;
        protected int features;

        protected AbstractBuilder(String template) {
            this.template = Objects.requireNonNull(template);
            this.features = globalFeatures;
        }

        public BuilderChild escape(char escape) {
            this.escape = escape;
            this.escape$set = true;
            return this.self();
        }

        public BuilderChild features(Feature ... newFeatures) {
            this.features = Feature.of(newFeatures);
            return this.self();
        }

        public BuilderChild addFeatures(Feature ... appendFeatures) {
            if (RsArray.isNotEmpty(appendFeatures)) {
                for (Feature feature : appendFeatures) {
                    this.features = feature.set(this.features);
                }
            }
            return this.self();
        }

        public BuilderChild removeFeatures(Feature ... removeFeatures) {
            if (RsArray.isNotEmpty(removeFeatures)) {
                for (Feature feature : removeFeatures) {
                    this.features = feature.clear(this.features);
                }
            }
            return this.self();
        }

        public BuilderChild defaultValue(String defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue);
            return this.self();
        }

        public BuilderChild defaultValue(UnaryOperator<String> defaultValueHandler) {
            this.defaultValueHandler = Objects.requireNonNull(defaultValueHandler);
            return this.self();
        }

        public TemplateChild build() {
            if (!this.escape$set) {
                this.escape = (char)92;
            }
            return this.buildInstance();
        }

        protected abstract BuilderChild self();

        protected abstract TemplateChild buildInstance();
    }
}

