/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text;

import java.util.function.Predicate;
import top.redscorpion.core.text.NamingCase;
import top.redscorpion.core.text.StringRegionMatcher;
import top.redscorpion.core.text.StringRepeater;
import top.redscorpion.core.text.StringTrimer;
import top.redscorpion.core.text.StringValidator;
import top.redscorpion.core.text.finder.CharFinder;
import top.redscorpion.core.text.finder.CharMatcherFinder;
import top.redscorpion.core.text.finder.StringFinder;
import top.redscorpion.core.text.placeholder.StringFormatter;
import top.redscorpion.core.text.replacer.RangeReplacerByChar;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsObject;

public class CharSequenceHandle
extends StringValidator {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String SPACE = " ";

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String emptyIfNull(CharSequence str) {
        return ((CharSequence)RsObject.defaultIfNull(str, "")).toString();
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultValue) {
        return CharSequenceHandle.isEmpty(str) ? defaultValue : str;
    }

    public static String trim(CharSequence str) {
        return StringTrimer.TRIM_BLANK.apply(str);
    }

    public static String trimPrefix(CharSequence str) {
        return StringTrimer.TRIM_PREFIX_BLANK.apply(str);
    }

    public static String trim(CharSequence str, StringTrimer.TrimMode mode, Predicate<Character> predicate) {
        return new StringTrimer(mode, predicate).apply(str);
    }

    public static boolean startWith(CharSequence str, char c) {
        if (CharSequenceHandle.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(0);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return CharSequenceHandle.startWith(str, prefix, false);
    }

    public static boolean startWithAnyIgnoreCase(CharSequence str, CharSequence ... suffixes) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceHandle.startWith(str, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        return CharSequenceHandle.startWith(str, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        return new StringRegionMatcher(ignoreCase, ignoreEquals, true).test(str, prefix);
    }

    public static boolean endWith(CharSequence str, char c) {
        if (CharSequenceHandle.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return CharSequenceHandle.endWith(str, suffix, false);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceHandle.endWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAnyIgnoreCase(CharSequence str, CharSequence ... suffixes) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceHandle.endWith(str, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        return CharSequenceHandle.endWith(str, suffix, ignoreCase, false);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase, boolean ignoreEquals) {
        return new StringRegionMatcher(ignoreCase, ignoreEquals, false).test(str, suffix);
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return CharSequenceHandle.indexOf(str, searchChar) > -1;
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceHandle.getContainsStr(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (CharSequenceHandle.isNotEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!RsArray.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsBlank(CharSequence str) {
        if (null == str) {
            return false;
        }
        int length = str.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!RsChar.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!CharSequenceHandle.contains(str, checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return CharSequenceHandle.indexOf(str, testStr, 0, true) > -1;
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceHandle.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!CharSequenceHandle.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return CharSequenceHandle.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return CharSequenceHandle.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence text, char searchChar, int start, int end) {
        if (CharSequenceHandle.isEmpty(text)) {
            return -1;
        }
        return new CharFinder(searchChar).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOf(CharSequence text, Predicate<Character> matcher, int start, int end) {
        if (CharSequenceHandle.isEmpty(text)) {
            return -1;
        }
        return new CharMatcherFinder(matcher).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return CharSequenceHandle.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return CharSequenceHandle.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence text, CharSequence searchStr, int from, boolean ignoreCase) {
        if (CharSequenceHandle.isEmpty(text) || CharSequenceHandle.isEmpty(searchStr)) {
            if (CharSequenceHandle.equals(text, searchStr)) {
                return 0;
            }
            return -1;
        }
        return StringFinder.of(searchStr, ignoreCase).setText(text).start(from);
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (null == str || RsArray.isEmpty(chars)) {
            return CharSequenceHandle.str(str);
        }
        return CharSequenceHandle.filter(str, c -> !RsArray.contains(chars, c.charValue()));
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        return CharSequenceHandle.removePrefix(str, prefix, false);
    }

    public static String removePrefix(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        if (CharSequenceHandle.isEmpty(str) || CharSequenceHandle.isEmpty(prefix)) {
            return CharSequenceHandle.str(str);
        }
        String str2 = str.toString();
        if (CharSequenceHandle.startWith(str, prefix, ignoreCase)) {
            return CharSequenceHandle.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (CharSequenceHandle.isEmpty(str) || CharSequenceHandle.isEmpty(suffix)) {
            return CharSequenceHandle.str(str);
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return CharSequenceHandle.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String cleanBlank(CharSequence str) {
        return CharSequenceHandle.filter(str, c -> !RsChar.isBlankChar(c.charValue()));
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        return CharSequenceHandle.prependIfMissing(str, prefix, prefix);
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        return CharSequenceHandle.appendIfMissing(str, suffix, new CharSequence[0]);
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (CharSequenceHandle.isEmpty(str)) {
            return CharSequenceHandle.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return "";
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String subPre(CharSequence string, int toIndexExclude) {
        return CharSequenceHandle.sub(string, 0, toIndexExclude);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (CharSequenceHandle.isEmpty(string)) {
            return null;
        }
        return CharSequenceHandle.sub(string, fromIndex, string.length());
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string)) {
            return null == string ? null : "";
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string)) {
            return null == string ? null : "";
        }
        if (separator == null) {
            return "";
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string)) {
            return null == string ? null : "";
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return "";
        }
        return str.substring(pos + 1);
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        return StringRepeater.of(count).repeat(c);
    }

    public static String repeatAndJoin(CharSequence str, int count, CharSequence delimiter) {
        if (count <= 0) {
            return "";
        }
        return StringRepeater.of(count).repeatAndJoin(str, delimiter);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return CharSequenceHandle.equals(str1, str2, false);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static boolean isSubEquals(CharSequence str1, int offset1, CharSequence str2, int offset2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, offset1, str2.toString(), offset2, length);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return "null";
        }
        if (RsArray.isEmpty(params) || CharSequenceHandle.isBlank(template)) {
            return template.toString();
        }
        return StringFormatter.format(template.toString(), params);
    }

    public static String unWrap(CharSequence str, char prefix, char suffix) {
        if (CharSequenceHandle.isEmpty(str)) {
            return CharSequenceHandle.str(str);
        }
        if (str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix) {
            return CharSequenceHandle.sub(str, 1, str.length() - 1);
        }
        return str.toString();
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str || str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (CharSequenceHandle.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return CharSequenceHandle.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... testSuffixes) {
        if (str == null || CharSequenceHandle.isEmpty(suffix) || CharSequenceHandle.endWith(str, suffix, ignoreCase)) {
            return CharSequenceHandle.str(str);
        }
        if (RsArray.isNotEmpty(testSuffixes)) {
            for (CharSequence testSuffix : testSuffixes) {
                if (!CharSequenceHandle.endWith(str, testSuffix, ignoreCase)) continue;
                return str.toString();
            }
        }
        return str.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return CharSequenceHandle.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || CharSequenceHandle.isEmpty(prefix) || CharSequenceHandle.startWith(str, prefix, ignoreCase)) {
            return CharSequenceHandle.str(str);
        }
        if (RsArray.isNotEmpty(prefixes)) {
            for (CharSequence s : prefixes) {
                if (!CharSequenceHandle.startWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return prefix.toString().concat(str.toString());
    }

    public static String replace(CharSequence str, int beginInclude, int endExclude, char replacedChar) {
        return new RangeReplacerByChar(beginInclude, endExclude, replacedChar).apply(str);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return CharSequenceHandle.replace(str, startInclude, endExclude, '*');
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + CharSequenceHandle.upperFirst(str);
    }

    public static String upperAt(CharSequence str, int index) {
        if (null == str) {
            return null;
        }
        int length = str.length();
        if (index < 0) {
            index += length;
        }
        String string = str.toString();
        if (index < 0 || index >= length) {
            return string;
        }
        char c = str.charAt(index);
        if (!Character.isLowerCase(c)) {
            return string;
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(index, Character.toUpperCase(c));
        return builder.toString();
    }

    public static String lowerAt(CharSequence str, int index) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (index < 0) {
            index += length;
        }
        String string = str.toString();
        if (index < 0 || index >= length) {
            return string;
        }
        char c = str.charAt(index);
        if (!Character.isUpperCase(c)) {
            return string;
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(index, Character.toLowerCase(c));
        return builder.toString();
    }

    public static String upperFirst(CharSequence str) {
        return CharSequenceHandle.upperAt(str, 0);
    }

    public static String lowerFirst(CharSequence str) {
        return CharSequenceHandle.lowerAt(str, 0);
    }

    public static String filter(CharSequence str, Predicate<Character> predicate) {
        if (str == null || predicate == null) {
            return CharSequenceHandle.str(str);
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!predicate.test(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence str) {
        return NamingCase.isUpperCase(str);
    }

    public static String toUnderlineCase(CharSequence str) {
        return NamingCase.toUnderlineCase(str);
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name);
    }

    public static String genSetter(CharSequence fieldName) {
        return CharSequenceHandle.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(CharSequence fieldName) {
        return CharSequenceHandle.upperFirstAndAddPre(fieldName, "get");
    }

    public static int indexOf(CharSequence str, CharSequence searchStr) {
        return CharSequenceHandle.indexOf(str, searchStr, 0);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex) {
        return CharSequenceHandle.indexOf(str, searchStr, fromIndex, false);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, boolean ignoreCase) {
        return CharSequenceHandle.indexOf(str, searchStr, 0, ignoreCase);
    }
}

