/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect.method;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.exception.RsExceptionHandle;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.lookup.RsLookup;
import top.redscorpion.core.reflect.method.RsMethod;

public class RsMethodHandle {
    public static <T> T invokeHandle(MethodHandle methodHandle, Object ... args) {
        try {
            return (T)methodHandle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw RsExceptionHandle.wrapRuntime(e);
        }
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws RsException {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        return RsMethodHandle.invokeExact(obj, method, RsMethod.actualArgs(method, args));
    }

    public static <T> T invokeExact(Object obj, Method method, Object ... args) throws RsException {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        try {
            MethodHandle handle = RsLookup.unreflectMethod(method);
            if (null != obj) {
                handle = handle.bindTo(obj);
            }
            return (T)handle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw RsExceptionHandle.wrapRuntime(e);
        }
    }
}

