/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang.tuple;

import java.util.Objects;
import top.redscorpion.core.lang.tuple.Pair;

public class Triple<L, M, R>
extends Pair<L, R> {
    private static final long serialVersionUID = 1L;
    protected M middle;

    public static <L, M, R> Triple<L, M, R> of(L left, M middle, R right) {
        return new Triple<L, M, R>(left, middle, right);
    }

    public Triple(L left, M middle, R right) {
        super(left, right);
        this.middle = middle;
    }

    public M getMiddle() {
        return this.middle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Triple) {
            Triple triple = (Triple)o;
            return Objects.equals(this.getLeft(), triple.getLeft()) && Objects.equals(this.getMiddle(), triple.getMiddle()) && Objects.equals(this.getRight(), triple.getRight());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.middle, this.right);
    }

    @Override
    public String toString() {
        return "Triple{left=" + this.getLeft() + ", middle=" + this.getMiddle() + ", right=" + this.getRight() + '}';
    }

    @Override
    public Triple<L, M, R> clone() {
        return (Triple)super.clone();
    }
}

