/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang.ansi;

import top.redscorpion.core.lang.ansi.Ansi4BitBackgroundColor;
import top.redscorpion.core.lang.ansi.AnsiElement;
import top.redscorpion.core.util.RsString;

public enum Ansi4BitColor implements AnsiElement
{
    DEFAULT(39),
    BLACK(30),
    RED(31),
    GREEN(32),
    YELLOW(33),
    BLUE(34),
    MAGENTA(35),
    CYAN(36),
    WHITE(37),
    BRIGHT_BLACK(90),
    BRIGHT_RED(91),
    BRIGHT_GREEN(92),
    BRIGHT_YELLOW(93),
    BRIGHT_BLUE(94),
    BRIGHT_MAGENTA(95),
    BRIGHT_CYAN(96),
    BRIGHT_WHITE(97);

    private final int code;

    private Ansi4BitColor(int code) {
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.getCode(false);
    }

    public int getCode(boolean isBackground) {
        return isBackground ? this.code + 10 : this.code;
    }

    public Ansi4BitBackgroundColor asBackground() {
        return Ansi4BitBackgroundColor.of(this.getCode(true));
    }

    @Override
    public String toString() {
        return RsString.toString(this.code);
    }

    public static Ansi4BitColor of(int code) {
        for (Ansi4BitColor item : Ansi4BitColor.values()) {
            if (item.getCode() != code) continue;
            return item;
        }
        throw new IllegalArgumentException(RsString.format("No matched Ansi4BitColor instance,code={}", code));
    }
}

