/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.resource;

import java.net.URL;
import top.redscorpion.core.io.resource.NoResourceException;
import top.redscorpion.core.io.resource.UrlResource;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsClassLoader;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsFileName;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;

public class ClassPathResource
extends UrlResource {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final ClassLoader classLoader;
    private final Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, null, null);
    }

    public ClassPathResource(String pathBaseClassLoader, ClassLoader classLoader, Class<?> clazz) {
        super((URL)null);
        String path;
        Assert.notNull(pathBaseClassLoader, "Path must not be null", new Object[0]);
        this.path = path = this.normalizePath(pathBaseClassLoader);
        this.name = RsString.isBlank(path) ? null : RsFileName.getName(path);
        this.classLoader = RsObject.defaultIfNull(classLoader, RsClassLoader::getClassLoader);
        this.clazz = clazz;
        this.initUrl();
    }

    private void initUrl() {
        this.url = null != this.clazz ? this.clazz.getResource(this.path) : (null != this.classLoader ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
        if (null == this.url) {
            throw new NoResourceException("Resource of path [{}] not exist!", new Object[]{this.path});
        }
    }

    @Override
    public String toString() {
        return null == this.path ? super.toString() : "classpath:" + this.path;
    }

    private String normalizePath(String path) {
        path = RsFile.normalize(path);
        path = RsString.removePrefix(path, "/");
        Assert.isFalse(RsFile.isAbsolutePath(path), "Path [{}] must be a relative path !", path);
        return path;
    }
}

