/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.file.visitor.CopyVisitor;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.copier.AbstractSrcToDestCopier;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsPath;

public class PathCopier
extends AbstractSrcToDestCopier<Path, PathCopier> {
    private static final long serialVersionUID = 1L;
    private final CopyOption[] options;

    public static PathCopier of(Path src, Path target, CopyOption[] options) {
        return new PathCopier(src, target, options);
    }

    public PathCopier(Path src, Path target, CopyOption[] options) {
        Assert.notNull(target, "Src path must be not null !", new Object[0]);
        if (!RsPath.exists(src, false)) {
            throw new IllegalArgumentException("Src path is not exist!");
        }
        this.src = src;
        this.target = Assert.notNull(target, "Target path must be not null !", new Object[0]);
        this.options = RsObject.defaultIfNull(options, new CopyOption[0]);
    }

    @Override
    public Path copy() throws IORuntimeException {
        if (RsPath.isDirectory((Path)this.src)) {
            if (RsPath.exists((Path)this.target, false)) {
                if (RsPath.isDirectory((Path)this.target)) {
                    return PathCopier.theCopyContent((Path)this.src, ((Path)this.target).resolve(((Path)this.src).getFileName()), this.options);
                }
                throw new IllegalArgumentException("Can not copy directory to a file!");
            }
            return PathCopier.theCopyContent((Path)this.src, (Path)this.target, this.options);
        }
        return PathCopier.copyFile((Path)this.src, (Path)this.target, this.options);
    }

    private static Path theCopyContent(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        try {
            Files.walkFileTree(src, new CopyVisitor(src, target, options));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return target;
    }

    private static Path copyFile(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Source file is null !", new Object[0]);
        Assert.notNull(target, "Target file or directory is null !", new Object[0]);
        Path targetPath = RsPath.isDirectory(target) ? target.resolve(src.getFileName()) : target;
        RsPath.mkParentDirs(targetPath);
        try {
            return Files.copy(src, targetPath, options);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

