/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.data.id;

import java.io.Serializable;
import java.util.Date;
import top.redscorpion.core.date.SystemClock;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.generator.Generator;
import top.redscorpion.core.util.RsId;
import top.redscorpion.core.util.RsRandom;

public class Snowflake
implements Generator<Long>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final long DEFAULT_TWEPOCH = 1288834974657L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long twepoch;
    private final long workerId;
    private final long dataCenterId;
    private final boolean useSystemClock;
    private final long randomSequenceLimit;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public Snowflake() {
        this(RsId.getWorkerId(RsId.getDataCenterId(31L), 31L));
    }

    public Snowflake(long workerId) {
        this(workerId, RsId.getDataCenterId(31L));
    }

    public Snowflake(long workerId, long dataCenterId) {
        this(workerId, dataCenterId, false);
    }

    public Snowflake(long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(null, workerId, dataCenterId, isUseSystemClock);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(epochDate, workerId, dataCenterId, isUseSystemClock, 0L);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock, long randomSequenceLimit) {
        this.twepoch = null != epochDate ? epochDate.getTime() : 1288834974657L;
        this.workerId = Assert.checkBetween(workerId, 0L, 31L);
        this.dataCenterId = Assert.checkBetween(dataCenterId, 0L, 31L);
        this.useSystemClock = isUseSystemClock;
        this.randomSequenceLimit = Assert.checkBetween(randomSequenceLimit, 0L, 4095L);
    }

    public long getWorkerId(long id) {
        return id >> 12 & 0x1FL;
    }

    public long getDataCenterId(long id) {
        return id >> 17 & 0x1FL;
    }

    public long getGenerateDateTime(long id) {
        return (id >> 22 & 0x1FFFFFFFFFFL) + this.twepoch;
    }

    @Override
    public synchronized Long next() {
        long timestamp = this.genTime();
        if (timestamp < this.lastTimestamp) {
            timestamp = this.lastTimestamp;
        }
        if (timestamp == this.lastTimestamp) {
            long sequence = this.sequence + 1L & 0xFFFL;
            if (sequence == 0L) {
                ++timestamp;
            }
            this.sequence = sequence;
        } else {
            this.sequence = this.randomSequenceLimit > 1L ? RsRandom.randomLong(this.randomSequenceLimit) : 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    public String nextStr() {
        return Long.toString(this.next());
    }

    private long genTime() {
        return this.useSystemClock ? SystemClock.now() : System.currentTimeMillis();
    }
}

