/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl.stringer;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.function.Function;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.impl.stringer.ClobStringer;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsIo;

public class BlobStringer
implements Function<Object, String> {
    public static ClobStringer INSTANCE = new ClobStringer();

    @Override
    public String apply(Object o) {
        return BlobStringer.blobToStr((Blob)o);
    }

    private static String blobToStr(Blob blob) {
        String string;
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            string = RsIo.read(in, RsCharset.UTF_8);
        }
        catch (SQLException e) {
            try {
                throw new ConvertException(e);
            }
            catch (Throwable throwable) {
                RsIo.closeQuietly(in);
                throw throwable;
            }
        }
        RsIo.closeQuietly(in);
        return string;
    }
}

